/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;

public enum KafkaReceiveAttributesGetter implements MessagingAttributesGetter<ConsumerRecords<?, ?>, Void>
{
    INSTANCE;


    public String system(ConsumerRecords<?, ?> consumerRecords) {
        return "kafka";
    }

    public String destinationKind(ConsumerRecords<?, ?> consumerRecords) {
        return "topic";
    }

    @Nullable
    public String destination(ConsumerRecords<?, ?> consumerRecords) {
        Set topics = consumerRecords.partitions().stream().map(TopicPartition::topic).collect(Collectors.toSet());
        return topics.size() == 1 ? (String)topics.iterator().next() : null;
    }

    public boolean temporaryDestination(ConsumerRecords<?, ?> consumerRecords) {
        return false;
    }

    @Nullable
    public String protocol(ConsumerRecords<?, ?> consumerRecords) {
        return null;
    }

    @Nullable
    public String protocolVersion(ConsumerRecords<?, ?> consumerRecords) {
        return null;
    }

    @Nullable
    public String url(ConsumerRecords<?, ?> consumerRecords) {
        return null;
    }

    @Nullable
    public String conversationId(ConsumerRecords<?, ?> consumerRecords) {
        return null;
    }

    @Nullable
    public Long messagePayloadSize(ConsumerRecords<?, ?> consumerRecords) {
        return null;
    }

    @Nullable
    public Long messagePayloadCompressedSize(ConsumerRecords<?, ?> consumerRecords) {
        return null;
    }

    @Nullable
    public String messageId(ConsumerRecords<?, ?> consumerRecords, @Nullable Void unused) {
        return null;
    }
}

