/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.kafka.internal.KafkaHeadersSetter;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.producer.ProducerRecord;

public final class KafkaPropagation {
    private static final KafkaHeadersSetter SETTER = KafkaHeadersSetter.INSTANCE;
    private static final boolean CLIENT_PROPAGATION_ENABLED = Config.get().getBoolean("otel.instrumentation.kafka.client-propagation.enabled", true);

    public static boolean isPropagationEnabled() {
        return CLIENT_PROPAGATION_ENABLED;
    }

    public static boolean shouldPropagate(ApiVersions apiVersions) {
        return apiVersions.maxUsableProduceMagic() >= 2 && KafkaPropagation.isPropagationEnabled();
    }

    public static <K, V> ProducerRecord<K, V> propagateContext(Context context, ProducerRecord<K, V> record) {
        try {
            KafkaPropagation.inject(context, record);
        }
        catch (IllegalStateException e) {
            record = new ProducerRecord(record.topic(), record.partition(), record.timestamp(), record.key(), record.value(), (Iterable)record.headers());
            KafkaPropagation.inject(context, record);
        }
        return record;
    }

    private static <K, V> void inject(Context context, ProducerRecord<K, V> record) {
        GlobalOpenTelemetry.getPropagators().getTextMapPropagator().inject(context, (Object)record.headers(), (TextMapSetter)SETTER);
    }

    private KafkaPropagation() {
    }
}

