/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.config.ExperimentalConfig;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingSpanNameExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaBatchProcessAttributesGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaBatchProcessSpanLinksExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerAdditionalAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerAttributesGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerRecordGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProducerAdditionalAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProducerAttributesGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaPropagation;
import io.opentelemetry.instrumentation.kafka.internal.KafkaReceiveAttributesGetter;
import java.util.Collections;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.ProducerRecord;

public final class KafkaInstrumenterFactory {
    private final OpenTelemetry openTelemetry;
    private final String instrumentationName;
    private ErrorCauseExtractor errorCauseExtractor = ErrorCauseExtractor.jdk();

    public KafkaInstrumenterFactory(OpenTelemetry openTelemetry, String instrumentationName) {
        this.openTelemetry = openTelemetry;
        this.instrumentationName = instrumentationName;
    }

    public KafkaInstrumenterFactory setErrorCauseExtractor(ErrorCauseExtractor errorCauseExtractor) {
        this.errorCauseExtractor = errorCauseExtractor;
        return this;
    }

    public Instrumenter<ProducerRecord<?, ?>, Void> createProducerInstrumenter() {
        return this.createProducerInstrumenter(Collections.emptyList());
    }

    public Instrumenter<ProducerRecord<?, ?>, Void> createProducerInstrumenter(Iterable<AttributesExtractor<ProducerRecord<?, ?>, Void>> extractors) {
        KafkaProducerAttributesGetter getter = KafkaProducerAttributesGetter.INSTANCE;
        MessageOperation operation = MessageOperation.SEND;
        return Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractor((AttributesExtractor)MessagingAttributesExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractors(extractors).addAttributesExtractor((AttributesExtractor)new KafkaProducerAdditionalAttributesExtractor()).setErrorCauseExtractor(this.errorCauseExtractor).newInstrumenter(SpanKindExtractor.alwaysProducer());
    }

    public Instrumenter<ConsumerRecords<?, ?>, Void> createConsumerReceiveInstrumenter() {
        KafkaReceiveAttributesGetter getter = KafkaReceiveAttributesGetter.INSTANCE;
        MessageOperation operation = MessageOperation.RECEIVE;
        return Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractor((AttributesExtractor)MessagingAttributesExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).setErrorCauseExtractor(this.errorCauseExtractor).setEnabled(ExperimentalConfig.get().messagingReceiveInstrumentationEnabled()).newInstrumenter(SpanKindExtractor.alwaysConsumer());
    }

    public Instrumenter<ConsumerRecord<?, ?>, Void> createConsumerProcessInstrumenter() {
        return this.createConsumerOperationInstrumenter(MessageOperation.PROCESS, Collections.emptyList());
    }

    public Instrumenter<ConsumerRecord<?, ?>, Void> createConsumerOperationInstrumenter(MessageOperation operation, Iterable<AttributesExtractor<ConsumerRecord<?, ?>, Void>> extractors) {
        KafkaConsumerAttributesGetter getter = KafkaConsumerAttributesGetter.INSTANCE;
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractor((AttributesExtractor)MessagingAttributesExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractor((AttributesExtractor)new KafkaConsumerAdditionalAttributesExtractor()).addAttributesExtractors(extractors).setErrorCauseExtractor(this.errorCauseExtractor);
        if (KafkaConsumerExperimentalAttributesExtractor.isEnabled()) {
            builder.addAttributesExtractor((AttributesExtractor)new KafkaConsumerExperimentalAttributesExtractor());
        }
        if (!KafkaPropagation.isPropagationEnabled()) {
            return builder.newInstrumenter(SpanKindExtractor.alwaysConsumer());
        }
        if (ExperimentalConfig.get().messagingReceiveInstrumentationEnabled()) {
            builder.addSpanLinksExtractor(SpanLinksExtractor.extractFromRequest((TextMapPropagator)this.openTelemetry.getPropagators().getTextMapPropagator(), (TextMapGetter)KafkaConsumerRecordGetter.INSTANCE));
            return builder.newInstrumenter(SpanKindExtractor.alwaysConsumer());
        }
        return builder.newConsumerInstrumenter((TextMapGetter)KafkaConsumerRecordGetter.INSTANCE);
    }

    public Instrumenter<ConsumerRecords<?, ?>, Void> createBatchProcessInstrumenter() {
        KafkaBatchProcessAttributesGetter getter = KafkaBatchProcessAttributesGetter.INSTANCE;
        MessageOperation operation = MessageOperation.PROCESS;
        return Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractor((AttributesExtractor)MessagingAttributesExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addSpanLinksExtractor((SpanLinksExtractor)new KafkaBatchProcessSpanLinksExtractor(this.openTelemetry.getPropagators().getTextMapPropagator())).setErrorCauseExtractor(this.errorCauseExtractor).newInstrumenter(SpanKindExtractor.alwaysConsumer());
    }
}

