/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.semconv.code.CodeAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.code.CodeAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.code.CodeSpanNameExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientMetrics;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientSpanNameExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.instrumentation.api.semconv.network.ServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.network.ServerAttributesGetter;
import io.opentelemetry.instrumentation.jdbc.internal.DataSourceCodeAttributesGetter;
import io.opentelemetry.instrumentation.jdbc.internal.DataSourceDbAttributesExtractor;
import io.opentelemetry.instrumentation.jdbc.internal.DbRequest;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcAttributesGetter;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcNetworkAttributesGetter;
import io.opentelemetry.instrumentation.jdbc.internal.TransactionAttributeExtractor;
import io.opentelemetry.instrumentation.jdbc.internal.dbinfo.DbInfo;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;

public final class JdbcInstrumenterFactory {
    public static final String INSTRUMENTATION_NAME = "io.opentelemetry.jdbc";
    private static final JdbcAttributesGetter dbAttributesGetter = new JdbcAttributesGetter();
    private static final JdbcNetworkAttributesGetter netAttributesGetter = new JdbcNetworkAttributesGetter();

    public static boolean captureQueryParameters() {
        return ConfigPropertiesUtil.getBoolean((String)"otel.instrumentation.jdbc.experimental.capture-query-parameters", (boolean)false);
    }

    public static Instrumenter<DbRequest, Void> createStatementInstrumenter(OpenTelemetry openTelemetry) {
        return JdbcInstrumenterFactory.createStatementInstrumenter(openTelemetry, JdbcInstrumenterFactory.captureQueryParameters());
    }

    static Instrumenter<DbRequest, Void> createStatementInstrumenter(OpenTelemetry openTelemetry, boolean captureQueryParameters) {
        return JdbcInstrumenterFactory.createStatementInstrumenter(openTelemetry, Collections.emptyList(), true, ConfigPropertiesUtil.getBoolean((String)"otel.instrumentation.common.db-statement-sanitizer.enabled", (boolean)true), captureQueryParameters);
    }

    public static Instrumenter<DbRequest, Void> createStatementInstrumenter(OpenTelemetry openTelemetry, boolean enabled, boolean statementSanitizationEnabled, boolean captureQueryParameters) {
        return JdbcInstrumenterFactory.createStatementInstrumenter(openTelemetry, Collections.emptyList(), enabled, statementSanitizationEnabled, captureQueryParameters);
    }

    public static Instrumenter<DbRequest, Void> createStatementInstrumenter(OpenTelemetry openTelemetry, List<AttributesExtractor<DbRequest, Void>> extractors, boolean enabled, boolean statementSanitizationEnabled, boolean captureQueryParameters) {
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)DbClientSpanNameExtractor.create((SqlClientAttributesGetter)dbAttributesGetter)).addAttributesExtractor(SqlClientAttributesExtractor.builder((SqlClientAttributesGetter)dbAttributesGetter).setStatementSanitizationEnabled(statementSanitizationEnabled).setCaptureQueryParameters(captureQueryParameters).build()).addAttributesExtractor((AttributesExtractor)ServerAttributesExtractor.create((ServerAttributesGetter)netAttributesGetter)).addAttributesExtractors(extractors).addOperationMetrics(DbClientMetrics.get()).setEnabled(enabled).buildInstrumenter(SpanKindExtractor.alwaysClient());
    }

    public static Instrumenter<DataSource, DbInfo> createDataSourceInstrumenter(OpenTelemetry openTelemetry, boolean enabled) {
        DataSourceCodeAttributesGetter getter = DataSourceCodeAttributesGetter.INSTANCE;
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)CodeSpanNameExtractor.create((CodeAttributesGetter)getter)).addAttributesExtractor(CodeAttributesExtractor.create((CodeAttributesGetter)getter)).addAttributesExtractor((AttributesExtractor)DataSourceDbAttributesExtractor.INSTANCE).setEnabled(enabled).buildInstrumenter();
    }

    public static Instrumenter<DbRequest, Void> createTransactionInstrumenter(OpenTelemetry openTelemetry) {
        return JdbcInstrumenterFactory.createTransactionInstrumenter(openTelemetry, ConfigPropertiesUtil.getBoolean((String)"otel.instrumentation.jdbc.experimental.transaction.enabled", (boolean)false));
    }

    public static Instrumenter<DbRequest, Void> createTransactionInstrumenter(OpenTelemetry openTelemetry, boolean enabled) {
        return JdbcInstrumenterFactory.createTransactionInstrumenter(openTelemetry, Collections.emptyList(), enabled);
    }

    public static Instrumenter<DbRequest, Void> createTransactionInstrumenter(OpenTelemetry openTelemetry, List<AttributesExtractor<DbRequest, Void>> extractors, boolean enabled) {
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, DbRequest::getOperation).addAttributesExtractor(SqlClientAttributesExtractor.builder((SqlClientAttributesGetter)dbAttributesGetter).build()).addAttributesExtractor((AttributesExtractor)TransactionAttributeExtractor.INSTANCE).addAttributesExtractor((AttributesExtractor)ServerAttributesExtractor.create((ServerAttributesGetter)netAttributesGetter)).addAttributesExtractors(extractors).setEnabled(enabled).buildInstrumenter(SpanKindExtractor.alwaysClient());
    }

    private JdbcInstrumenterFactory() {
    }
}

