/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import io.opentelemetry.instrumentation.jdbc.internal.DbInfo;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcConnectionUrlParser;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcMaps;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdbcUtils {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUtils.class);
    private static @Nullable Field c3poField = null;

    public static Connection connectionFromStatement(Statement statement) {
        Connection connection;
        try {
            connection = statement.getConnection();
            if (c3poField != null && connection.getClass().getName().equals("com.mchange.v2.c3p0.impl.NewProxyConnection")) {
                return (Connection)c3poField.get(connection);
            }
            try {
                if (connection.isWrapperFor(Connection.class)) {
                    connection = connection.unwrap(Connection.class);
                }
            }
            catch (AbstractMethodError | Exception e) {
                Class<?> connectionClass;
                if (connection != null && (connectionClass = connection.getClass()).getName().equals("com.mchange.v2.c3p0.impl.NewProxyConnection")) {
                    Field inner = connectionClass.getDeclaredField("inner");
                    inner.setAccessible(true);
                    c3poField = inner;
                    return (Connection)c3poField.get(connection);
                }
            }
        }
        catch (Throwable e) {
            logger.debug("Could not get connection for StatementAdvice", e);
            return null;
        }
        return connection;
    }

    public static DbInfo extractDbInfo(Connection connection) {
        return (DbInfo)JdbcMaps.connectionInfo.computeIfAbsent((Object)connection, JdbcUtils::computeDbInfo);
    }

    public static DbInfo computeDbInfo(Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String url = metaData.getURL();
            if (url != null) {
                try {
                    return JdbcConnectionUrlParser.parse(url, connection.getClientInfo());
                }
                catch (Throwable ex) {
                    return JdbcConnectionUrlParser.parse(url, null);
                }
            }
            return DbInfo.DEFAULT;
        }
        catch (SQLException se) {
            return DbInfo.DEFAULT;
        }
    }

    private JdbcUtils() {
    }
}

