/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.instrumentation.api.instrumenter.db.SqlAttributesExtractor;
import io.opentelemetry.instrumentation.jdbc.internal.DbInfo;
import io.opentelemetry.instrumentation.jdbc.internal.DbRequest;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JdbcAttributesExtractor
extends SqlAttributesExtractor<DbRequest, Void> {
    protected @Nullable String system(DbRequest request) {
        return request.getDbInfo().getSystem();
    }

    protected @Nullable String user(DbRequest request) {
        return request.getDbInfo().getUser();
    }

    protected @Nullable String name(DbRequest request) {
        DbInfo dbInfo = request.getDbInfo();
        return dbInfo.getName() == null ? dbInfo.getDb() : dbInfo.getName();
    }

    protected @Nullable String connectionString(DbRequest request) {
        return request.getDbInfo().getShortUrl();
    }

    protected AttributeKey<String> dbTableAttribute() {
        return SemanticAttributes.DB_SQL_TABLE;
    }

    protected @Nullable String rawStatement(DbRequest request) {
        return request.getStatement();
    }
}

