/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import com.google.auto.value.AutoValue;
import io.opentelemetry.instrumentation.jdbc.internal.AutoValue_DbRequest;
import io.opentelemetry.instrumentation.jdbc.internal.DbInfo;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcMaps;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
public abstract class DbRequest {
    public static @Nullable DbRequest create(PreparedStatement statement) {
        return DbRequest.create(statement, (String)JdbcMaps.preparedStatements.get((Object)statement));
    }

    public static @Nullable DbRequest create(Statement statement, String dbStatementString) {
        Connection connection = JdbcUtils.connectionFromStatement(statement);
        if (connection == null) {
            return null;
        }
        return DbRequest.create(JdbcUtils.extractDbInfo(connection), dbStatementString);
    }

    public static DbRequest create(DbInfo dbInfo, String statement) {
        return new AutoValue_DbRequest(dbInfo, statement);
    }

    public abstract DbInfo getDbInfo();

    public abstract @Nullable String getStatement();
}

