/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import io.opentelemetry.instrumentation.jdbc.internal.JdbcConnectionUrlParser;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcData;
import io.opentelemetry.instrumentation.jdbc.internal.dbinfo.DbInfo;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class JdbcUtils {
    private static final Logger logger = Logger.getLogger(JdbcUtils.class.getName());
    @Nullable
    private static Field c3poField = null;

    public static Connection connectionFromStatement(Statement statement) {
        Connection connection;
        try {
            connection = statement.getConnection();
            if (c3poField != null && connection.getClass().getName().equals("com.mchange.v2.c3p0.impl.NewProxyConnection")) {
                return (Connection)c3poField.get(connection);
            }
            try {
                if (connection.isWrapperFor(Connection.class)) {
                    connection = connection.unwrap(Connection.class);
                }
            }
            catch (AbstractMethodError | Exception e) {
                Class<?> connectionClass;
                if (connection != null && (connectionClass = connection.getClass()).getName().equals("com.mchange.v2.c3p0.impl.NewProxyConnection")) {
                    Field inner = connectionClass.getDeclaredField("inner");
                    inner.setAccessible(true);
                    c3poField = inner;
                    return (Connection)c3poField.get(connection);
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.FINE, "Could not get connection for StatementAdvice", e);
            return null;
        }
        return connection;
    }

    public static DbInfo extractDbInfo(Connection connection) {
        DbInfo dbInfo = (DbInfo)JdbcData.connectionInfo.get((Object)connection);
        if (dbInfo == null) {
            dbInfo = JdbcUtils.computeDbInfo(connection);
            JdbcData.connectionInfo.set((Object)connection, (Object)JdbcData.intern(dbInfo));
        }
        return dbInfo;
    }

    public static DbInfo computeDbInfo(Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String url = metaData.getURL();
            if (url != null) {
                try {
                    return JdbcConnectionUrlParser.parse(url, connection.getClientInfo());
                }
                catch (Throwable ex) {
                    return JdbcConnectionUrlParser.parse(url, null);
                }
            }
            return DbInfo.DEFAULT;
        }
        catch (SQLException se) {
            return DbInfo.DEFAULT;
        }
    }

    private JdbcUtils() {
    }
}

