/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.jdbc.internal.DbRequest;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcSingletons;
import io.opentelemetry.instrumentation.jdbc.internal.ThrowingSupplier;
import io.opentelemetry.instrumentation.jdbc.internal.dbinfo.DbInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;

public class OpenTelemetryStatement<S extends Statement>
implements Statement {
    protected final S delegate;
    protected final DbInfo dbInfo;
    protected final String query;
    private final ArrayList<String> batchCommands = new ArrayList();

    OpenTelemetryStatement(S delegate, DbInfo dbInfo) {
        this(delegate, dbInfo, null);
    }

    OpenTelemetryStatement(S delegate, DbInfo dbInfo, String query) {
        this.delegate = delegate;
        this.dbInfo = dbInfo;
        this.query = query;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.wrapCall(sql, () -> this.delegate.executeQuery(sql));
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.wrapCall(sql, () -> this.delegate.executeUpdate(sql));
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.wrapCall(sql, () -> this.delegate.executeUpdate(sql, autoGeneratedKeys));
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.wrapCall(sql, () -> this.delegate.executeUpdate(sql, columnIndexes));
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.wrapCall(sql, () -> this.delegate.executeUpdate(sql, columnNames));
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.wrapCall(sql, () -> this.delegate.execute(sql));
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.wrapCall(sql, () -> this.delegate.execute(sql, autoGeneratedKeys));
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.wrapCall(sql, () -> this.delegate.execute(sql, columnIndexes));
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.wrapCall(sql, () -> this.delegate.execute(sql, columnNames));
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.wrapCall(this.buildSqlForBatch(), () -> this.delegate.executeBatch());
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.delegate.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.delegate.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.delegate.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.delegate.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.delegate.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.delegate.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.delegate.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.delegate.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.delegate.setCursorName(name);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.delegate.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.delegate.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.delegate.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.delegate.getMoreResults(current);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.delegate.getFetchDirection();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.delegate.setFetchDirection(direction);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.delegate.getFetchSize();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.delegate.setFetchSize(rows);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.delegate.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.delegate.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.delegate.addBatch(sql);
        this.batchCommands.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.delegate.clearBatch();
        this.batchCommands.clear();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.delegate.getGeneratedKeys();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.delegate.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.delegate.isPoolable();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.delegate.setPoolable(poolable);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.delegate.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.delegate.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    protected <T, E extends Exception> T wrapCall(String sql, ThrowingSupplier<T, E> callable) throws E {
        T result;
        Context parentContext = Context.current();
        DbRequest request = DbRequest.create(this.dbInfo, sql);
        if (!JdbcSingletons.instrumenter().shouldStart(parentContext, (Object)request)) {
            return callable.call();
        }
        Context context = JdbcSingletons.instrumenter().start(parentContext, (Object)request);
        try (Scope ignored = context.makeCurrent();){
            result = callable.call();
        }
        catch (Throwable t) {
            JdbcSingletons.instrumenter().end(context, (Object)request, null, t);
            throw t;
        }
        JdbcSingletons.instrumenter().end(context, (Object)request, null, null);
        return result;
    }

    private String buildSqlForBatch() {
        StringBuilder sqlBuilder = new StringBuilder();
        if (this.query != null) {
            sqlBuilder.append(this.query);
        }
        for (String batchCommand : this.batchCommands) {
            sqlBuilder.append(batchCommand);
        }
        return sqlBuilder.toString();
    }
}

