/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.config;

import java.time.Duration;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

final class ConfigValueParsers {
    static List<String> parseList(String value) {
        return Collections.unmodifiableList(ConfigValueParsers.filterBlanksAndNulls(value.split(",")));
    }

    static Map<String, String> parseMap(String value) {
        return ConfigValueParsers.parseList(value).stream().map(keyValuePair -> ConfigValueParsers.filterBlanksAndNulls(keyValuePair.split("=", 2))).map(splitKeyValuePairs -> {
            if (splitKeyValuePairs.size() != 2) {
                throw new IllegalArgumentException("Invalid map property, should be formatted key1=value1,key2=value2: " + value);
            }
            return new AbstractMap.SimpleImmutableEntry<String, String>((String)splitKeyValuePairs.get(0), (String)splitKeyValuePairs.get(1));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (first, next) -> next, LinkedHashMap::new));
    }

    private static List<String> filterBlanksAndNulls(String[] values) {
        return Arrays.stream(values).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    static Duration parseDuration(String value) {
        String unitString = ConfigValueParsers.getUnitString(value);
        String numberString = value.substring(0, value.length() - unitString.length());
        long rawNumber = Long.parseLong(numberString.trim());
        TimeUnit unit = ConfigValueParsers.getDurationUnit(unitString.trim());
        return Duration.ofMillis(TimeUnit.MILLISECONDS.convert(rawNumber, unit));
    }

    private static TimeUnit getDurationUnit(String unitString) {
        switch (unitString) {
            case "": 
            case "ms": {
                return TimeUnit.MILLISECONDS;
            }
            case "s": {
                return TimeUnit.SECONDS;
            }
            case "m": {
                return TimeUnit.MINUTES;
            }
            case "h": {
                return TimeUnit.HOURS;
            }
            case "d": {
                return TimeUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("Invalid duration string, found: " + unitString);
    }

    private static String getUnitString(String rawValue) {
        char c;
        int lastDigitIndex;
        for (lastDigitIndex = rawValue.length() - 1; lastDigitIndex >= 0 && !Character.isDigit(c = rawValue.charAt(lastDigitIndex)); --lastDigitIndex) {
        }
        return rawValue.substring(lastDigitIndex + 1);
    }

    private ConfigValueParsers() {
    }
}

