/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.net;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class NetAttributesExtractor<REQUEST, RESPONSE>
extends AttributesExtractor<REQUEST, RESPONSE> {
    @Override
    protected final void onStart(AttributesBuilder attributes, REQUEST request) {
        NetAttributesExtractor.set(attributes, SemanticAttributes.NET_TRANSPORT, this.transport(request));
        NetAttributesExtractor.set(attributes, SemanticAttributes.NET_PEER_IP, this.peerIp(request, null));
        NetAttributesExtractor.set(attributes, SemanticAttributes.NET_PEER_NAME, this.peerName(request, null));
        Integer peerPort = this.peerPort(request, null);
        if (peerPort != null) {
            NetAttributesExtractor.set(attributes, SemanticAttributes.NET_PEER_PORT, Long.valueOf(peerPort.intValue()));
        }
    }

    @Override
    protected final void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response) {
        NetAttributesExtractor.set(attributes, SemanticAttributes.NET_PEER_IP, this.peerIp(request, response));
        NetAttributesExtractor.set(attributes, SemanticAttributes.NET_PEER_NAME, this.peerName(request, response));
        Integer peerPort = this.peerPort(request, response);
        if (peerPort != null) {
            NetAttributesExtractor.set(attributes, SemanticAttributes.NET_PEER_PORT, Long.valueOf(peerPort.intValue()));
        }
    }

    public abstract @Nullable String transport(REQUEST var1);

    public abstract @Nullable String peerName(REQUEST var1, @Nullable RESPONSE var2);

    public abstract @Nullable Integer peerPort(REQUEST var1, @Nullable RESPONSE var2);

    public abstract @Nullable String peerIp(REQUEST var1, @Nullable RESPONSE var2);
}

