/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleValueRecorder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.common.Labels;
import io.opentelemetry.api.metrics.common.LabelsBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.annotations.UnstableApi;
import io.opentelemetry.instrumentation.api.instrumenter.RequestListener;
import io.opentelemetry.instrumentation.api.instrumenter.RequestMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.AutoValue_HttpClientMetrics_State;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnstableApi
public final class HttpClientMetrics
implements RequestListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> HTTP_CLIENT_REQUEST_METRICS_STATE = ContextKey.named((String)"http-client-request-metrics-state");
    private static final Logger logger = LoggerFactory.getLogger(HttpClientMetrics.class);
    private final DoubleValueRecorder duration;

    @UnstableApi
    public static RequestMetrics get() {
        return HttpClientMetrics::new;
    }

    private HttpClientMetrics(Meter meter) {
        this.duration = meter.doubleValueRecorderBuilder("http.client.duration").setUnit("milliseconds").setDescription("The duration of the outbound HTTP request").build();
    }

    @Override
    public Context start(Context context, Attributes requestAttributes) {
        long startTimeNanos = System.nanoTime();
        Labels durationLabels = HttpClientMetrics.durationLabels(requestAttributes);
        return context.with(HTTP_CLIENT_REQUEST_METRICS_STATE, (Object)new AutoValue_HttpClientMetrics_State(durationLabels, startTimeNanos));
    }

    @Override
    public void end(Context context, Attributes responseAttributes) {
        State state = (State)context.get(HTTP_CLIENT_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.debug("No state present when ending context {}. Cannot record HTTP request metrics.", (Object)context);
            return;
        }
        this.duration.record((double)(System.nanoTime() - state.startTimeNanos()) / NANOS_PER_MS, state.durationLabels());
    }

    private static Labels durationLabels(Attributes attributes) {
        LabelsBuilder labels = Labels.builder();
        attributes.forEach((key, value) -> {
            switch (key.getKey()) {
                case "http.method": 
                case "http.host": 
                case "http.scheme": 
                case "http.flavor": 
                case "http.server_name": 
                case "net.host.name": {
                    if (!(value instanceof String)) break;
                    labels.put(key.getKey(), (String)value);
                    break;
                }
                case "http.status_code": 
                case "net.host.port": {
                    if (!(value instanceof Long)) break;
                    labels.put(key.getKey(), Long.toString((Long)value));
                    break;
                }
            }
        });
        return labels.build();
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Labels durationLabels();

        abstract long startTimeNanos();
    }
}

