/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.annotations.UnstableApi;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ClientInstrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.EndTimeExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.RequestListener;
import io.opentelemetry.instrumentation.api.instrumenter.RequestMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.ServerInstrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinkExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.StartTimeExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class InstrumenterBuilder<REQUEST, RESPONSE> {
    final OpenTelemetry openTelemetry;
    final Meter meter;
    final String instrumentationName;
    final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    final List<AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors = new ArrayList<AttributesExtractor<? super REQUEST, ? super RESPONSE>>();
    final List<SpanLinkExtractor<? super REQUEST>> spanLinkExtractors = new ArrayList<SpanLinkExtractor<? super REQUEST>>();
    final List<RequestListener> requestListeners = new ArrayList<RequestListener>();
    SpanKindExtractor<? super REQUEST> spanKindExtractor = SpanKindExtractor.alwaysInternal();
    SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor = SpanStatusExtractor.getDefault();
    ErrorCauseExtractor errorCauseExtractor = ErrorCauseExtractor.jdk();
    @Nullable StartTimeExtractor<REQUEST> startTimeExtractor = null;
    @Nullable EndTimeExtractor<RESPONSE> endTimeExtractor = null;

    InstrumenterBuilder(OpenTelemetry openTelemetry, String instrumentationName, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        this.openTelemetry = openTelemetry;
        this.meter = GlobalMeterProvider.get().get(instrumentationName);
        this.instrumentationName = instrumentationName;
        this.spanNameExtractor = spanNameExtractor;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setSpanStatusExtractor(SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor) {
        this.spanStatusExtractor = spanStatusExtractor;
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractor(AttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor) {
        this.attributesExtractors.add(attributesExtractor);
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractors(Iterable<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors) {
        attributesExtractors.forEach(this.attributesExtractors::add);
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractors(AttributesExtractor<? super REQUEST, ? super RESPONSE> ... attributesExtractors) {
        return this.addAttributesExtractors(Arrays.asList(attributesExtractors));
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addSpanLinkExtractor(SpanLinkExtractor<REQUEST> spanLinkExtractor) {
        this.spanLinkExtractors.add(spanLinkExtractor);
        return this;
    }

    @UnstableApi
    public InstrumenterBuilder<REQUEST, RESPONSE> addRequestMetrics(RequestMetrics factory) {
        this.requestListeners.add(factory.create(this.meter));
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setErrorCauseExtractor(ErrorCauseExtractor errorCauseExtractor) {
        this.errorCauseExtractor = errorCauseExtractor;
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setTimeExtractors(StartTimeExtractor<REQUEST> startTimeExtractor, EndTimeExtractor<RESPONSE> endTimeExtractor) {
        this.startTimeExtractor = Objects.requireNonNull(startTimeExtractor);
        this.endTimeExtractor = Objects.requireNonNull(endTimeExtractor);
        return this;
    }

    public Instrumenter<REQUEST, RESPONSE> newClientInstrumenter(TextMapSetter<REQUEST> setter) {
        return this.newInstrumenter(InstrumenterConstructor.propagatingToDownstream(setter), SpanKindExtractor.alwaysClient());
    }

    public Instrumenter<REQUEST, RESPONSE> newServerInstrumenter(TextMapGetter<REQUEST> getter) {
        return this.newUpstreamPropagatingInstrumenter(SpanKindExtractor.alwaysServer(), getter);
    }

    public Instrumenter<REQUEST, RESPONSE> newProducerInstrumenter(TextMapSetter<REQUEST> setter) {
        return this.newInstrumenter(InstrumenterConstructor.propagatingToDownstream(setter), SpanKindExtractor.alwaysProducer());
    }

    public Instrumenter<REQUEST, RESPONSE> newConsumerInstrumenter(TextMapGetter<REQUEST> getter) {
        return this.newUpstreamPropagatingInstrumenter(SpanKindExtractor.alwaysConsumer(), getter);
    }

    public Instrumenter<REQUEST, RESPONSE> newUpstreamPropagatingInstrumenter(SpanKindExtractor<REQUEST> spanKindExtractor, TextMapGetter<REQUEST> getter) {
        return this.newInstrumenter(InstrumenterConstructor.propagatingFromUpstream(getter), spanKindExtractor);
    }

    public Instrumenter<REQUEST, RESPONSE> newInstrumenter() {
        return this.newInstrumenter(InstrumenterConstructor.internal(), SpanKindExtractor.alwaysInternal());
    }

    public Instrumenter<REQUEST, RESPONSE> newInstrumenter(SpanKindExtractor<? super REQUEST> spanKindExtractor) {
        return this.newInstrumenter(InstrumenterConstructor.internal(), spanKindExtractor);
    }

    private Instrumenter<REQUEST, RESPONSE> newInstrumenter(InstrumenterConstructor<REQUEST, RESPONSE> constructor, SpanKindExtractor<? super REQUEST> spanKindExtractor) {
        this.spanKindExtractor = spanKindExtractor;
        return constructor.create(this);
    }

    private static interface InstrumenterConstructor<RQ, RS> {
        public Instrumenter<RQ, RS> create(InstrumenterBuilder<RQ, RS> var1);

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> internal() {
            return Instrumenter::new;
        }

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> propagatingToDownstream(TextMapSetter<RQ> setter) {
            return builder -> new ClientInstrumenter(builder, setter);
        }

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> propagatingFromUpstream(TextMapGetter<RQ> getter) {
            return builder -> new ServerInstrumenter(builder, getter);
        }
    }
}

