/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.servlet;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.tracer.ServerSpan;
import java.util.function.Supplier;

public final class ServerSpanNaming {
    private static final ContextKey<ServerSpanNaming> CONTEXT_KEY = ContextKey.named((String)"opentelemetry-servlet-span-naming-key");
    private volatile Source updatedBySource;
    private volatile int nameLength;

    public static Context init(Context context, Source initialSource) {
        ServerSpanNaming serverSpanNaming = (ServerSpanNaming)context.get(CONTEXT_KEY);
        if (serverSpanNaming != null) {
            serverSpanNaming.updatedBySource = initialSource;
            return context;
        }
        return context.with(CONTEXT_KEY, (Object)new ServerSpanNaming(initialSource));
    }

    private ServerSpanNaming(Source initialSource) {
        this.updatedBySource = initialSource;
    }

    public static void updateServerSpanName(Context context, Source source, Supplier<String> serverSpanName) {
        String name;
        boolean onlyIfBetterName;
        Span serverSpan = ServerSpan.fromContextOrNull(context);
        if (serverSpan == null) {
            return;
        }
        ServerSpanNaming serverSpanNaming = (ServerSpanNaming)context.get(CONTEXT_KEY);
        if (serverSpanNaming == null) {
            String name2 = serverSpanName.get();
            if (name2 != null && !name2.isEmpty()) {
                serverSpan.updateName(name2);
            }
            return;
        }
        boolean bl = onlyIfBetterName = !source.useFirst && source.order == serverSpanNaming.updatedBySource.order;
        if (!(source.order <= serverSpanNaming.updatedBySource.order && !onlyIfBetterName || (name = serverSpanName.get()) == null || name.isEmpty() || onlyIfBetterName && !serverSpanNaming.isBetterName(name))) {
            serverSpan.updateName(name);
            serverSpanNaming.updatedBySource = source;
            serverSpanNaming.nameLength = name.length();
        }
    }

    private boolean isBetterName(String name) {
        return name.length() > this.nameLength;
    }

    @Deprecated
    public static void updateSource(Context context, Source source) {
        ServerSpanNaming serverSpanNaming = (ServerSpanNaming)context.get(CONTEXT_KEY);
        if (serverSpanNaming != null && source.order > serverSpanNaming.updatedBySource.order) {
            serverSpanNaming.updatedBySource = source;
        }
    }

    public static enum Source {
        CONTAINER(1),
        FILTER(2, false),
        SERVLET(3),
        CONTROLLER(4);

        private final int order;
        private final boolean useFirst;

        private Source(int order) {
            this(order, true);
        }

        private Source(int order, boolean useFirst) {
            this.order = order;
            this.useFirst = useFirst;
        }
    }
}

