/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.config;

import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.config.NamingConvention;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class ConfigBuilder {
    private final Map<String, String> allProperties = new HashMap<String, String>();

    public ConfigBuilder readProperties(Properties properties) {
        for (String name : properties.stringPropertyNames()) {
            this.allProperties.put(NamingConvention.DOT.normalize(name), properties.getProperty(name));
        }
        return this;
    }

    public ConfigBuilder readProperties(Map<String, String> properties) {
        return this.fromConfigMap(properties, NamingConvention.DOT);
    }

    public ConfigBuilder readEnvironmentVariables() {
        return this.fromConfigMap(System.getenv(), NamingConvention.ENV_VAR);
    }

    public ConfigBuilder readSystemProperties() {
        return this.readProperties(System.getProperties());
    }

    private ConfigBuilder fromConfigMap(Map<String, String> configMap, NamingConvention namingConvention) {
        for (Map.Entry<String, String> entry : configMap.entrySet()) {
            this.allProperties.put(namingConvention.normalize(entry.getKey()), entry.getValue());
        }
        return this;
    }

    public Config build() {
        return Config.create(Collections.unmodifiableMap(new HashMap<String, String>(this.allProperties)));
    }
}

