/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.instrumenter.SpanSuppressor;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Set;

enum SpanSuppressionStrategy {
    NONE{

        @Override
        SpanSuppressor create(Set<SpanKey> spanKeys) {
            return SpanSuppressor.Noop.INSTANCE;
        }
    }
    ,
    SPAN_KIND{
        private final SpanSuppressor strategy;
        {
            EnumMap<SpanKind, SpanSuppressor> delegates = new EnumMap<SpanKind, SpanSuppressor>(SpanKind.class);
            delegates.put(SpanKind.SERVER, new SpanSuppressor.BySpanKey(Collections.singleton(SpanKey.KIND_SERVER)));
            delegates.put(SpanKind.CLIENT, new SpanSuppressor.BySpanKey(Collections.singleton(SpanKey.KIND_CLIENT)));
            delegates.put(SpanKind.CONSUMER, new SpanSuppressor.BySpanKey(Collections.singleton(SpanKey.KIND_CONSUMER)));
            delegates.put(SpanKind.PRODUCER, new SpanSuppressor.BySpanKey(Collections.singleton(SpanKey.KIND_PRODUCER)));
            this.strategy = new SpanSuppressor.DelegateBySpanKind(delegates);
        }

        @Override
        SpanSuppressor create(Set<SpanKey> spanKeys) {
            return this.strategy;
        }
    }
    ,
    SEMCONV{

        @Override
        SpanSuppressor create(Set<SpanKey> spanKeys) {
            if (spanKeys.isEmpty()) {
                return SpanSuppressor.Noop.INSTANCE;
            }
            return new SpanSuppressor.BySpanKey(spanKeys);
        }
    };


    abstract SpanSuppressor create(Set<SpanKey> var1);

    static SpanSuppressionStrategy fromConfig(Config config) {
        String value = config.getString("otel.instrumentation.experimental.span-suppression-strategy", "semconv");
        switch (value.toLowerCase(Locale.ROOT)) {
            case "none": {
                return NONE;
            }
            case "span-kind": {
                return SPAN_KIND;
            }
        }
        return SEMCONV;
    }
}

