/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.tracer.async;

import io.opentelemetry.instrumentation.api.tracer.async.AsyncSpanEndStrategy;
import io.opentelemetry.instrumentation.api.tracer.async.Jdk8AsyncSpanEndStrategy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AsyncSpanEndStrategies {
    private static final AsyncSpanEndStrategies instance = new AsyncSpanEndStrategies();
    private final List<AsyncSpanEndStrategy> strategies = new CopyOnWriteArrayList<AsyncSpanEndStrategy>();

    public static AsyncSpanEndStrategies getInstance() {
        return instance;
    }

    private AsyncSpanEndStrategies() {
        this.strategies.add(Jdk8AsyncSpanEndStrategy.INSTANCE);
    }

    public void registerStrategy(AsyncSpanEndStrategy strategy) {
        Objects.requireNonNull(strategy);
        this.strategies.add(strategy);
    }

    public void unregisterStrategy(AsyncSpanEndStrategy strategy) {
        this.strategies.remove(strategy);
    }

    public void unregisterStrategy(Class<? extends AsyncSpanEndStrategy> strategyClass) {
        this.strategies.removeIf(strategy -> strategy.getClass() == strategyClass);
    }

    public @Nullable AsyncSpanEndStrategy resolveStrategy(Class<?> returnType) {
        for (AsyncSpanEndStrategy strategy : this.strategies) {
            if (!strategy.supports(returnType)) continue;
            return strategy;
        }
        return null;
    }
}

