/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.db;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.instrumentation.api.db.SqlStatementSanitizer;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbAttributesExtractor;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SqlAttributesExtractor<REQUEST>
extends DbAttributesExtractor<REQUEST> {
    @Override
    protected final void onStart(AttributesBuilder attributes, REQUEST request) {
        super.onStart(attributes, request);
        AttributeKey<String> dbTable = this.dbTableAttribute();
        if (dbTable != null) {
            SqlAttributesExtractor.set(attributes, dbTable, this.dbTable(request));
        }
    }

    @Override
    protected final @Nullable String dbStatement(REQUEST request) {
        return this.sanitize(request).getFullStatement();
    }

    @Override
    protected final @Nullable String dbOperation(REQUEST request) {
        return this.sanitize(request).getOperation();
    }

    protected final @Nullable String dbTable(REQUEST request) {
        return this.sanitize(request).getTable();
    }

    private SqlStatementInfo sanitize(REQUEST request) {
        return SqlStatementSanitizer.sanitize(this.rawDbStatement(request));
    }

    protected abstract @Nullable AttributeKey<String> dbTableAttribute();

    protected abstract @Nullable String rawDbStatement(REQUEST var1);
}

