/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.tracer.utils;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NetPeerUtils {
    public static final NetPeerUtils INSTANCE = new NetPeerUtils(Config.get());
    private final Map<String, String> peerServiceMapping;

    NetPeerUtils(Config config) {
        this.peerServiceMapping = Collections.unmodifiableMap(config.getMapProperty("otel.instrumentation.common.peer-service-mapping"));
    }

    public void setNetPeer(Span span, @Nullable InetSocketAddress remoteConnection) {
        this.setNetPeer((arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1), remoteConnection);
    }

    public void setNetPeer(SpanBuilder span, @Nullable InetSocketAddress remoteConnection) {
        this.setNetPeer((arg_0, arg_1) -> ((SpanBuilder)span).setAttribute(arg_0, arg_1), remoteConnection);
    }

    public void setNetPeer(SpanAttributeSetter span, @Nullable InetSocketAddress remoteConnection) {
        if (remoteConnection != null) {
            InetAddress remoteAddress = remoteConnection.getAddress();
            if (remoteAddress != null) {
                this.setNetPeer(span, remoteAddress.getHostName(), remoteAddress.getHostAddress(), remoteConnection.getPort());
            } else {
                this.setNetPeer(span, remoteConnection.getHostString(), null, remoteConnection.getPort());
            }
        }
    }

    public void setNetPeer(SpanBuilder span, InetAddress remoteAddress, int port) {
        this.setNetPeer((arg_0, arg_1) -> ((SpanBuilder)span).setAttribute(arg_0, arg_1), remoteAddress.getHostName(), remoteAddress.getHostAddress(), port);
    }

    public void setNetPeer(Span span, String nameOrIp, int port) {
        try {
            InetSocketAddress address = new InetSocketAddress(nameOrIp, port);
            this.setNetPeer(span, address);
        }
        catch (IllegalArgumentException iae) {
            this.setNetPeer((arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1), nameOrIp, null, port);
        }
    }

    public void setNetPeer(Span span, String peerName, String peerIp) {
        this.setNetPeer((arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1), peerName, peerIp, -1);
    }

    public void setNetPeer(Span span, String peerName, String peerIp, int port) {
        this.setNetPeer((arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1), peerName, peerIp, port);
    }

    public void setNetPeer(SpanAttributeSetter span, String peerName, String peerIp, int port) {
        String peerService;
        if (peerName != null && !peerName.equals(peerIp)) {
            span.setAttribute(SemanticAttributes.NET_PEER_NAME, peerName);
        }
        if (peerIp != null) {
            span.setAttribute(SemanticAttributes.NET_PEER_IP, peerIp);
        }
        if ((peerService = this.mapToPeerService(peerName)) == null) {
            peerService = this.mapToPeerService(peerIp);
        }
        if (peerService != null) {
            span.setAttribute(SemanticAttributes.PEER_SERVICE, peerService);
        }
        if (port > 0) {
            span.setAttribute(SemanticAttributes.NET_PEER_PORT, Long.valueOf(port));
        }
    }

    private String mapToPeerService(String endpoint) {
        if (endpoint == null) {
            return null;
        }
        return this.peerServiceMapping.get(endpoint);
    }

    @FunctionalInterface
    public static interface SpanAttributeSetter {
        public <T> void setAttribute(AttributeKey<T> var1, @Nullable T var2);
    }
}

