/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.tracer;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.InstrumentationVersion;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.context.ContextPropagationDebug;
import io.opentelemetry.instrumentation.api.tracer.ClientSpan;
import io.opentelemetry.instrumentation.api.tracer.ServerSpan;
import io.opentelemetry.instrumentation.api.tracer.SupportabilityMetrics;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class BaseTracer {
    private static final SupportabilityMetrics supportability = new SupportabilityMetrics(Config.get()).start();
    private final Tracer tracer;
    private final ContextPropagators propagators;

    public BaseTracer() {
        this(GlobalOpenTelemetry.get());
    }

    @Deprecated
    public BaseTracer(Tracer tracer) {
        this.tracer = tracer;
        this.propagators = GlobalOpenTelemetry.getPropagators();
    }

    public BaseTracer(OpenTelemetry openTelemetry) {
        this.tracer = openTelemetry.getTracer(this.getInstrumentationName(), this.getVersion());
        this.propagators = openTelemetry.getPropagators();
    }

    protected abstract String getInstrumentationName();

    protected String getVersion() {
        return InstrumentationVersion.VERSION;
    }

    public final boolean shouldStartSpan(Context context, SpanKind proposedKind) {
        boolean suppressed = false;
        switch (proposedKind) {
            case CLIENT: {
                suppressed = this.inClientSpan(context);
                break;
            }
            case SERVER: {
                suppressed = this.inServerSpan(context);
                break;
            }
        }
        if (suppressed) {
            supportability.recordSuppressedSpan(proposedKind, this.getInstrumentationName());
        }
        return !suppressed;
    }

    private boolean inClientSpan(Context context) {
        return ClientSpan.fromContextOrNull(context) != null;
    }

    private boolean inServerSpan(Context context) {
        return ServerSpan.fromContextOrNull(context) != null;
    }

    public Context startSpan(String spanName) {
        return this.startSpan(spanName, SpanKind.INTERNAL);
    }

    public Context startSpan(String spanName, SpanKind kind) {
        return this.startSpan(Context.current(), spanName, kind);
    }

    public Context startSpan(Context parentContext, String spanName, SpanKind kind) {
        Span span = this.spanBuilder(parentContext, spanName, kind).startSpan();
        return parentContext.with((ImplicitContextKeyed)span);
    }

    protected final SpanBuilder spanBuilder(Context parentContext, String spanName, SpanKind kind) {
        return this.tracer.spanBuilder(spanName).setSpanKind(kind).setParent(parentContext);
    }

    protected final Context withClientSpan(Context parentContext, Span span) {
        return ClientSpan.with(parentContext.with((ImplicitContextKeyed)span), span);
    }

    protected final Context withServerSpan(Context parentContext, Span span) {
        return ServerSpan.with(parentContext.with((ImplicitContextKeyed)span), span);
    }

    public static String spanNameForMethod(Method method) {
        return BaseTracer.spanNameForMethod(method.getDeclaringClass(), method.getName());
    }

    public static String spanNameForMethod(Class<?> clazz, @Nullable Method method) {
        return BaseTracer.spanNameForMethod(clazz, method == null ? "<unknown>" : method.getName());
    }

    public static String spanNameForMethod(Class<?> cl, String methodName) {
        return BaseTracer.spanNameForClass(cl) + "." + methodName;
    }

    public static String spanNameForClass(Class<?> clazz) {
        String pkgName;
        if (!clazz.isAnonymousClass()) {
            return clazz.getSimpleName();
        }
        String className = clazz.getName();
        if (clazz.getPackage() != null && !(pkgName = clazz.getPackage().getName()).isEmpty()) {
            className = className.substring(pkgName.length() + 1);
        }
        return className;
    }

    public void end(Context context) {
        this.end(context, -1L);
    }

    public void end(Context context, long endTimeNanos) {
        Span span = Span.fromContext((Context)context);
        if (endTimeNanos > 0L) {
            span.end(endTimeNanos, TimeUnit.NANOSECONDS);
        } else {
            span.end();
        }
    }

    public void endExceptionally(Context context, Throwable throwable) {
        this.endExceptionally(context, throwable, -1L);
    }

    public void endExceptionally(Context context, Throwable throwable, long endTimeNanos) {
        Span span = Span.fromContext((Context)context);
        span.setStatus(StatusCode.ERROR);
        this.onError(span, this.unwrapThrowable(throwable));
        this.end(context, endTimeNanos);
    }

    protected void onError(Span span, Throwable throwable) {
        this.addThrowable(span, throwable);
    }

    protected Throwable unwrapThrowable(Throwable throwable) {
        return throwable instanceof ExecutionException ? throwable.getCause() : throwable;
    }

    public void addThrowable(Span span, Throwable throwable) {
        span.recordException(throwable);
    }

    public <C> Context extract(C carrier, TextMapGetter<C> getter) {
        ContextPropagationDebug.debugContextLeakIfEnabled();
        return this.propagators.getTextMapPropagator().extract(Context.root(), carrier, getter);
    }

    public <C> void inject(Context context, C carrier, TextMapSetter<C> setter) {
        this.propagators.getTextMapPropagator().inject(context, carrier, setter);
    }
}

