/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.servlet;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;

public class ServletSpanNaming {
    private static final ContextKey<ServletSpanNaming> CONTEXT_KEY = ContextKey.named((String)"opentelemetry-servlet-span-naming-key");
    private volatile boolean servletUpdatedServerSpanName = false;

    public static Context init(Context context) {
        if (context.get(CONTEXT_KEY) != null) {
            return context;
        }
        return context.with(CONTEXT_KEY, (Object)new ServletSpanNaming());
    }

    private ServletSpanNaming() {
    }

    public static boolean shouldUpdateServerSpanName(Context context) {
        ServletSpanNaming servletSpanNaming = (ServletSpanNaming)context.get(CONTEXT_KEY);
        if (servletSpanNaming != null) {
            return !servletSpanNaming.servletUpdatedServerSpanName;
        }
        return false;
    }

    public static void setServletUpdatedServerSpanName(Context context) {
        ServletSpanNaming servletSpanNaming = (ServletSpanNaming)context.get(CONTEXT_KEY);
        if (servletSpanNaming != null) {
            servletSpanNaming.servletUpdatedServerSpanName = true;
        }
    }
}

