/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.db.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.internal.SqlCommenter;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public final class SqlCommenterBuilder {
    private boolean enabled;
    private BiFunction<Object, Boolean, TextMapPropagator> propagator = (unused1, unused2) -> W3CTraceContextPropagator.getInstance();
    private Predicate<Object> prepend = unused -> false;

    SqlCommenterBuilder() {
    }

    @CanIgnoreReturnValue
    public SqlCommenterBuilder setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @CanIgnoreReturnValue
    public SqlCommenterBuilder setPrepend(boolean prepend) {
        this.prepend = unused -> prepend;
        return this;
    }

    @CanIgnoreReturnValue
    public SqlCommenterBuilder setPrepend(Predicate<Object> prepend) {
        this.prepend = prepend;
        return this;
    }

    @CanIgnoreReturnValue
    public SqlCommenterBuilder setPropagator(TextMapPropagator propagator) {
        this.propagator = (unused1, unused2) -> propagator;
        return this;
    }

    @CanIgnoreReturnValue
    public SqlCommenterBuilder setPropagator(BiFunction<Object, Boolean, TextMapPropagator> propagator) {
        this.propagator = propagator;
        return this;
    }

    public SqlCommenter build() {
        return new SqlCommenter(this.enabled, this.propagator, this.prepend);
    }
}

