/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.contrib.sampler.RuleBasedRoutingSampler;
import io.opentelemetry.contrib.sampler.SamplingRule;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class RuleBasedRoutingSamplerBuilder {
    private final List<SamplingRule> rules = new ArrayList<SamplingRule>();
    private final SpanKind kind;
    private final Sampler defaultDelegate;

    RuleBasedRoutingSamplerBuilder(SpanKind kind, Sampler defaultDelegate) {
        this.kind = kind;
        this.defaultDelegate = defaultDelegate;
    }

    @CanIgnoreReturnValue
    public RuleBasedRoutingSamplerBuilder drop(AttributeKey<String> attributeKey, String pattern) {
        return this.customize(attributeKey, pattern, Sampler.alwaysOff());
    }

    @CanIgnoreReturnValue
    public RuleBasedRoutingSamplerBuilder customize(AttributeKey<String> attributeKey, String pattern, Sampler sampler) {
        this.rules.add(new SamplingRule(Objects.requireNonNull(attributeKey, "attributeKey must not be null"), Objects.requireNonNull(pattern, "pattern must not be null"), Objects.requireNonNull(sampler, "sampler must not be null")));
        return this;
    }

    @CanIgnoreReturnValue
    public RuleBasedRoutingSamplerBuilder recordAndSample(AttributeKey<String> attributeKey, String pattern) {
        return this.customize(attributeKey, pattern, Sampler.alwaysOn());
    }

    public RuleBasedRoutingSampler build() {
        return new RuleBasedRoutingSampler(this.rules, this.kind, this.defaultDelegate);
    }
}

