/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.samplers;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.contrib.samplers.RuleBasedRoutingSampler;
import io.opentelemetry.contrib.samplers.SamplingRule;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class RuleBasedRoutingSamplerBuilder {
    private final List<SamplingRule> rules = new ArrayList<SamplingRule>();
    private final SpanKind kind;
    private final Sampler defaultDelegate;

    RuleBasedRoutingSamplerBuilder(SpanKind kind, Sampler defaultDelegate) {
        this.kind = kind;
        this.defaultDelegate = defaultDelegate;
    }

    @CanIgnoreReturnValue
    public RuleBasedRoutingSamplerBuilder drop(AttributeKey<String> attributeKey, String pattern) {
        this.rules.add(new SamplingRule(Objects.requireNonNull(attributeKey, "attributeKey must not be null"), Objects.requireNonNull(pattern, "pattern must not be null"), Sampler.alwaysOff()));
        return this;
    }

    @CanIgnoreReturnValue
    public RuleBasedRoutingSamplerBuilder recordAndSample(AttributeKey<String> attributeKey, String pattern) {
        this.rules.add(new SamplingRule(Objects.requireNonNull(attributeKey, "attributeKey must not be null"), Objects.requireNonNull(pattern, "pattern must not be null"), Sampler.alwaysOn()));
        return this;
    }

    public RuleBasedRoutingSampler build() {
        return new RuleBasedRoutingSampler(this.rules, this.kind, this.defaultDelegate);
    }
}

