/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.samplers;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.samplers.RuleBasedRoutingSamplerBuilder;
import io.opentelemetry.contrib.samplers.SamplingRule;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import java.util.Objects;

public final class RuleBasedRoutingSampler
implements Sampler {
    private final List<SamplingRule> rules;
    private final SpanKind kind;
    private final Sampler fallback;

    RuleBasedRoutingSampler(List<SamplingRule> rules, SpanKind kind, Sampler fallback) {
        this.kind = Objects.requireNonNull(kind);
        this.fallback = Objects.requireNonNull(fallback);
        this.rules = Objects.requireNonNull(rules);
    }

    public static RuleBasedRoutingSamplerBuilder builder(SpanKind kind, Sampler fallback) {
        return new RuleBasedRoutingSamplerBuilder(Objects.requireNonNull(kind, "span kind must not be null"), Objects.requireNonNull(fallback, "fallback sampler must not be null"));
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        if (this.kind != spanKind) {
            return this.fallback.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
        }
        for (SamplingRule samplingRule : this.rules) {
            String attributeValue = (String)attributes.get(samplingRule.attributeKey);
            if (attributeValue == null || !samplingRule.pattern.matcher(attributeValue).find()) continue;
            return samplingRule.delegate.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
        }
        return this.fallback.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    public String getDescription() {
        return "RuleBasedRoutingSampler{rules=" + this.rules + ", kind=" + this.kind + ", fallback=" + this.fallback + '}';
    }

    public String toString() {
        return this.getDescription();
    }
}

