/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.attach;

import io.opentelemetry.javaagent.OpenTelemetryAgent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;

final class AgentFileProvider {
    static File getAgentFile() {
        AgentFileProvider.verifyExistenceOfAgentJarFile();
        Path tempDirPath = AgentFileProvider.createTempDir();
        Path tempAgentJarPath = AgentFileProvider.createTempAgentJarFile(tempDirPath);
        AgentFileProvider.deleteTempDirOnJvmExit(tempDirPath, tempAgentJarPath);
        return tempAgentJarPath.toFile();
    }

    private static void deleteTempDirOnJvmExit(Path tempDirPath, Path tempAgentJarPath) {
        tempAgentJarPath.toFile().deleteOnExit();
        tempDirPath.toFile().deleteOnExit();
    }

    private static void verifyExistenceOfAgentJarFile() {
        CodeSource codeSource = OpenTelemetryAgent.class.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            throw new IllegalStateException("could not get agent jar location");
        }
    }

    private static Path createTempDir() {
        Path tempDir;
        try {
            tempDir = Files.createTempDirectory("otel-agent", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Runtime attachment can't create temp directory", e);
        }
        return tempDir;
    }

    private static Path createTempAgentJarFile(Path tempDir) {
        URL url = OpenTelemetryAgent.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            return AgentFileProvider.copyTo(url, tempDir, "agent.jar");
        }
        catch (IOException e) {
            throw new IllegalStateException("Runtime attachment can't create agent jar file in temp directory", e);
        }
    }

    private static Path copyTo(URL url, Path tempDir, String fileName) throws IOException {
        Path tempFile = tempDir.resolve(fileName);
        try (InputStream in = url.openStream();){
            Files.copy(in, tempFile, new CopyOption[0]);
        }
        return tempFile;
    }

    private AgentFileProvider() {
    }
}

