/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.resourceproviders;

import io.opentelemetry.contrib.resourceproviders.AppServer;
import io.opentelemetry.contrib.resourceproviders.AppServerServiceNameDetector;
import io.opentelemetry.contrib.resourceproviders.DelegatingServiceNameDetector;
import io.opentelemetry.contrib.resourceproviders.GlassfishAppServer;
import io.opentelemetry.contrib.resourceproviders.JettyAppServer;
import io.opentelemetry.contrib.resourceproviders.LibertyAppService;
import io.opentelemetry.contrib.resourceproviders.ResourceLocator;
import io.opentelemetry.contrib.resourceproviders.ServiceNameDetector;
import io.opentelemetry.contrib.resourceproviders.TomcatAppServer;
import io.opentelemetry.contrib.resourceproviders.TomeeAppServer;
import io.opentelemetry.contrib.resourceproviders.WebSphereAppServer;
import io.opentelemetry.contrib.resourceproviders.WebSphereServiceNameDetector;
import io.opentelemetry.contrib.resourceproviders.WildflyAppServer;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

final class CommonAppServersServiceNameDetector {
    static ServiceNameDetector create() {
        return new DelegatingServiceNameDetector(CommonAppServersServiceNameDetector.detectors());
    }

    private CommonAppServersServiceNameDetector() {
    }

    private static List<ServiceNameDetector> detectors() {
        ResourceLocatorImpl locator = new ResourceLocatorImpl();
        return Arrays.asList(CommonAppServersServiceNameDetector.detectorFor(new TomeeAppServer(locator)), CommonAppServersServiceNameDetector.detectorFor(new TomcatAppServer(locator)), CommonAppServersServiceNameDetector.detectorFor(new JettyAppServer(locator)), CommonAppServersServiceNameDetector.detectorFor(new LibertyAppService(locator)), CommonAppServersServiceNameDetector.detectorFor(new WildflyAppServer(locator)), CommonAppServersServiceNameDetector.detectorFor(new GlassfishAppServer(locator)), new WebSphereServiceNameDetector(new WebSphereAppServer(locator)));
    }

    private static AppServerServiceNameDetector detectorFor(AppServer appServer) {
        return new AppServerServiceNameDetector(appServer);
    }

    private static class ResourceLocatorImpl
    implements ResourceLocator {
        private ResourceLocatorImpl() {
        }

        @Override
        @Nullable
        public Class<?> findClass(String className) {
            try {
                return Class.forName(className, false, ClassLoader.getSystemClassLoader());
            }
            catch (ClassNotFoundException | LinkageError exception) {
                return null;
            }
        }

        @Override
        public URL getClassLocation(Class<?> clazz) {
            return clazz.getProtectionDomain().getCodeSource().getLocation();
        }
    }
}

