/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.resourceproviders;

import com.google.errorprone.annotations.MustBeClosed;
import io.opentelemetry.contrib.resourceproviders.AppServer;
import io.opentelemetry.contrib.resourceproviders.ParseBuddy;
import io.opentelemetry.contrib.resourceproviders.ServiceNameDetector;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nullable;

final class AppServerServiceNameDetector
implements ServiceNameDetector {
    private static final Logger logger = Logger.getLogger(AppServerServiceNameDetector.class.getName());
    private final AppServer appServer;
    private final ParseBuddy parseBuddy;
    private final DirectoryTool dirTool;

    AppServerServiceNameDetector(AppServer appServer) {
        this(appServer, new ParseBuddy(appServer), new DirectoryTool());
    }

    AppServerServiceNameDetector(AppServer appServer, ParseBuddy parseBuddy, DirectoryTool dirTool) {
        this.appServer = appServer;
        this.parseBuddy = parseBuddy;
        this.dirTool = dirTool;
    }

    @Override
    @Nullable
    public String detect() throws Exception {
        if (this.appServer.getServerClass() == null) {
            return null;
        }
        Path deploymentDir = this.appServer.getDeploymentDir();
        if (deploymentDir == null) {
            return null;
        }
        if (!this.dirTool.isDirectory(deploymentDir)) {
            logger.log(Level.FINE, "Deployment dir {0} doesn't exist.", deploymentDir);
            return null;
        }
        logger.log(Level.FINE, "Looking for deployments in {0}.", deploymentDir);
        try (Stream<Path> stream = this.dirTool.list(deploymentDir);){
            String string = stream.map(this::detectName).filter(Objects::nonNull).findFirst().orElse(null);
            return string;
        }
    }

    @Nullable
    private String detectName(Path path) {
        if (!this.appServer.isValidAppName(path)) {
            logger.log(Level.FINE, "Skipping {0}.", path);
            return null;
        }
        logger.log(Level.FINE, "Attempting service name detection in {0}.", path);
        String name = path.getFileName().toString();
        if (this.dirTool.isDirectory(path)) {
            return this.parseBuddy.handleExplodedApp(path);
        }
        if (name.endsWith(".war")) {
            return this.parseBuddy.handlePackagedWar(path);
        }
        if (this.appServer.supportsEar() && name.endsWith(".ear")) {
            return this.parseBuddy.handlePackagedEar(path);
        }
        return null;
    }

    static class DirectoryTool {
        DirectoryTool() {
        }

        boolean isDirectory(Path path) {
            return Files.isDirectory(path, new LinkOption[0]);
        }

        @MustBeClosed
        Stream<Path> list(Path path) throws IOException {
            return Files.list(path);
        }
    }
}

