/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.resourceproviders;

import io.opentelemetry.contrib.resourceproviders.AppServer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ParseBuddy {
    private static final Logger logger = Logger.getLogger(ParseBuddy.class.getName());
    private final AppServer appServer;
    private final Filesystem filesystem;

    ParseBuddy(AppServer appServer) {
        this(appServer, new Filesystem());
    }

    ParseBuddy(AppServer appServer, Filesystem filesystem) {
        this.appServer = appServer;
        this.filesystem = filesystem;
    }

    @Nullable
    String handleExplodedApp(Path path) {
        String warResult = this.handleExplodedWar(path);
        if (warResult != null) {
            return warResult;
        }
        if (this.appServer.supportsEar()) {
            return this.handleExplodedEar(path);
        }
        return null;
    }

    @Nullable
    String handlePackagedWar(Path path) {
        return this.handlePackaged(path, "WEB-INF/web.xml", ParseBuddy.newWebXmlHandler());
    }

    @Nullable
    String handlePackagedEar(Path path) {
        return this.handlePackaged(path, "META-INF/application.xml", ParseBuddy.newAppXmlHandler());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String handlePackaged(Path path, String descriptorPath, DescriptorHandler handler) {
        try (ZipFile zip = this.filesystem.openZipFile(path);){
            ZipEntry zipEntry = zip.getEntry(descriptorPath);
            if (zipEntry == null) return null;
            String string = this.handle(() -> zip.getInputStream(zipEntry), path, handler);
            return string;
        }
        catch (IOException exception) {
            if (!logger.isLoggable(Level.WARNING)) return null;
            logger.log(Level.WARNING, "Failed to read '" + descriptorPath + "' from zip '" + path + "'.", exception);
        }
        return null;
    }

    @Nullable
    String handleExplodedWar(Path path) {
        return this.handleExploded(path, path.resolve("WEB-INF/web.xml"), ParseBuddy.newWebXmlHandler());
    }

    @Nullable
    String handleExplodedEar(Path path) {
        return this.handleExploded(path, path.resolve("META-INF/application.xml"), ParseBuddy.newAppXmlHandler());
    }

    @Nullable
    private String handleExploded(Path path, Path descriptor, DescriptorHandler handler) {
        if (this.filesystem.isRegularFile(descriptor)) {
            return this.handle(() -> this.filesystem.newInputStream(descriptor), path, handler);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String handle(InputStreamSupplier supplier, Path path, DescriptorHandler handler) {
        try (InputStream inputStream = supplier.supply();){
            String candidate = ParseBuddy.parseDescriptor(inputStream, handler);
            if (!this.appServer.isValidResult(path, candidate)) return null;
            String string = candidate;
            return string;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to parse descriptor", exception);
        }
        return null;
    }

    @Nullable
    private static String parseDescriptor(InputStream inputStream, DescriptorHandler handler) throws ParserConfigurationException, SAXException, IOException {
        if (SaxParserFactoryHolder.saxParserFactory == null) {
            return null;
        }
        SAXParser saxParser = SaxParserFactoryHolder.saxParserFactory.newSAXParser();
        saxParser.parse(inputStream, (DefaultHandler)handler);
        return handler.displayName;
    }

    private static DescriptorHandler newWebXmlHandler() {
        return new DescriptorHandler("web-app");
    }

    private static DescriptorHandler newAppXmlHandler() {
        return new DescriptorHandler("application");
    }

    static class Filesystem {
        Filesystem() {
        }

        boolean isRegularFile(Path path) {
            return Files.isRegularFile(path, new LinkOption[0]);
        }

        InputStream newInputStream(Path path) throws IOException {
            return Files.newInputStream(path, new OpenOption[0]);
        }

        ZipFile openZipFile(Path path) throws IOException {
            return new ZipFile(path.toFile());
        }
    }

    private static final class DescriptorHandler
    extends DefaultHandler {
        private final String rootElementName;
        private final Deque<String> currentElement = new ArrayDeque<String>();
        private boolean setDisplayName;
        @Nullable
        private String displayName;

        DescriptorHandler(String rootElementName) {
            this.rootElementName = rootElementName;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (this.displayName == null && this.rootElementName.equals(this.currentElement.peek()) && "display-name".equals(qName)) {
                String lang = attributes.getValue("xml:lang");
                if (lang == null || "".equals(lang)) {
                    lang = "en";
                }
                if ("en".equals(lang)) {
                    this.setDisplayName = true;
                }
            }
            this.currentElement.push(qName);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.currentElement.pop();
            this.setDisplayName = false;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.setDisplayName) {
                this.displayName = new String(ch, start, length);
            }
        }
    }

    private static interface InputStreamSupplier {
        public InputStream supply() throws IOException;
    }

    private static class SaxParserFactoryHolder {
        @Nullable
        private static final SAXParserFactory saxParserFactory = SaxParserFactoryHolder.getSaxParserFactory();

        private SaxParserFactoryHolder() {
        }

        @Nullable
        private static SAXParserFactory getSaxParserFactory() {
            try {
                return SAXParserFactory.newInstance();
            }
            catch (Throwable throwable) {
                logger.log(Level.FINE, "XML parser not available.", throwable);
                return null;
            }
        }
    }
}

