/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.resourceproviders;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.contrib.resourceproviders.AppServer;
import io.opentelemetry.contrib.resourceproviders.ResourceLocator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class JettyAppServer
implements AppServer {
    private static final Logger logger = Logger.getLogger(JettyAppServer.class.getName());
    private static final String SERVER_CLASS_NAME = "org.eclipse.jetty.start.Main";
    private final ResourceLocator locator;

    JettyAppServer(ResourceLocator locator) {
        this.locator = locator;
    }

    @Override
    public boolean isValidAppName(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return !path.getFileName().toString().endsWith(".d");
        }
        return true;
    }

    @Override
    public Path getDeploymentDir() {
        Path jettyBase;
        String programArguments = System.getProperty("sun.java.command");
        logger.log(Level.FINE, "Started with arguments {0}.", programArguments);
        if (programArguments != null && (jettyBase = JettyAppServer.parseJettyBase(programArguments)) != null) {
            logger.log(Level.FINE, "Using jetty.base {0}.", jettyBase);
            return jettyBase.resolve("webapps");
        }
        return Paths.get("webapps", new String[0]).toAbsolutePath();
    }

    @Override
    @Nullable
    public Class<?> getServerClass() {
        return this.locator.findClass(SERVER_CLASS_NAME);
    }

    @Nullable
    @VisibleForTesting
    static Path parseJettyBase(String programArguments) {
        Path candidate;
        if (programArguments == null) {
            return null;
        }
        int start = programArguments.indexOf("jetty.base=");
        if (start == -1) {
            return null;
        }
        if ((start += "jetty.base=".length()) == programArguments.length()) {
            return null;
        }
        int next = start;
        do {
            int nextSpace;
            if ((nextSpace = programArguments.indexOf(32, next)) == -1) {
                candidate = Paths.get(programArguments.substring(start), new String[0]);
                return Files.exists(candidate, new LinkOption[0]) ? candidate : null;
            }
            candidate = Paths.get(programArguments.substring(start, nextSpace), new String[0]);
            next = nextSpace + 1;
        } while (!Files.exists(candidate, new LinkOption[0]));
        return candidate;
    }

    @Override
    public boolean supportsEar() {
        return false;
    }
}

