/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.resourceproviders;

import io.opentelemetry.contrib.resourceproviders.AppServer;
import io.opentelemetry.contrib.resourceproviders.ResourceLocator;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

class GlassfishAppServer
implements AppServer {
    private static final String SERVICE_CLASS_NAME = "com.sun.enterprise.glassfish.bootstrap.ASMain";
    private final ResourceLocator locator;

    GlassfishAppServer(ResourceLocator locator) {
        this.locator = locator;
    }

    @Override
    @Nullable
    public Path getDeploymentDir() {
        String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
        if (instanceRoot == null) {
            return null;
        }
        return Paths.get(instanceRoot, "autodeploy");
    }

    @Override
    @Nullable
    public Class<?> getServerClass() {
        return this.locator.findClass(SERVICE_CLASS_NAME);
    }
}

