/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.resourceproviders;

import io.opentelemetry.contrib.resourceproviders.ParseBuddy;
import io.opentelemetry.contrib.resourceproviders.ServiceNameDetector;
import io.opentelemetry.contrib.resourceproviders.WebSphereAppServer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

class WebSphereServiceNameDetector
implements ServiceNameDetector {
    private static final Pattern COMMANDLINE_PARSE_PATTERN = Pattern.compile("com\\.ibm\\.wsspi\\.bootstrap\\.WSPreLauncher (.*) com\\.ibm\\.ws\\.runtime\\.WsServer (.+) ([^ ]+) ([^ ]+) ([^ ]+)");
    private static final Logger logger = Logger.getLogger(WebSphereServiceNameDetector.class.getName());
    private final WebSphereAppServer appServer;

    WebSphereServiceNameDetector(WebSphereAppServer appServer) {
        this.appServer = appServer;
    }

    @Override
    @Nullable
    public String detect() throws Exception {
        Path parent;
        if (this.appServer.getServerClass() == null) {
            return null;
        }
        String programArguments = System.getProperty("sun.java.command");
        logger.log(Level.FINE, "Started with arguments {0}.", programArguments);
        if (programArguments == null) {
            return null;
        }
        Matcher matcher = COMMANDLINE_PARSE_PATTERN.matcher(programArguments);
        if (!matcher.matches()) {
            logger.fine("Failed to parse arguments.");
            return null;
        }
        Path configDirectory = Paths.get(matcher.group(2), new String[0]);
        if (!Files.isDirectory(configDirectory, new LinkOption[0])) {
            logger.log(Level.FINE, "Missing configuration directory {0}.", configDirectory);
            return null;
        }
        String cell = matcher.group(3);
        String node = matcher.group(4);
        String server = matcher.group(5);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Parsed arguments: cell {0}, node {1}, server {2}, configuration directory {3}.", new Object[]{cell, node, server, configDirectory});
        }
        if ((parent = configDirectory.getParent()) == null) {
            return null;
        }
        Path cellApplications = parent.resolve("installedApps").resolve(cell);
        if (Files.isDirectory(cellApplications, new LinkOption[0])) {
            logger.log(Level.FINE, "Looking for deployments in {0}.", cellApplications);
            try (Stream<Path> stream = Files.list(cellApplications);){
                for (Path path : stream.collect(Collectors.toList())) {
                    String result;
                    List wars;
                    String fullName = path.getFileName().toString();
                    if (!fullName.endsWith(".ear") || !this.appServer.isValidAppName(path)) {
                        logger.log(Level.FINE, "Skipping {0}.", path);
                        continue;
                    }
                    logger.log(Level.FINE, "Attempting service name detection in {0}.", path);
                    String name = fullName.substring(0, fullName.length() - 4);
                    try (Stream<Path> warStream = Files.list(path);){
                        wars = warStream.filter(p -> p.getFileName().toString().endsWith(".war")).collect(Collectors.toList());
                    }
                    boolean maybeWarDeployment = wars.size() == 1 && ((Path)wars.get(0)).getFileName().toString().equals(name + ".war");
                    ParseBuddy parseBuddy = new ParseBuddy(this.appServer);
                    if (maybeWarDeployment && (result = parseBuddy.handleExplodedWar((Path)wars.get(0))) != null) {
                        String string = result;
                        return string;
                    }
                    result = parseBuddy.handleExplodedEar(path);
                    if (result == null || maybeWarDeployment && result.startsWith(name)) continue;
                    String string = result;
                    return string;
                }
            }
        }
        return null;
    }
}

