/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.resourceproviders;

import io.opentelemetry.contrib.resourceproviders.AppServer;
import io.opentelemetry.contrib.resourceproviders.ResourceLocator;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class LibertyAppService
implements AppServer {
    private static final String SERVICE_CLASS_NAME = "com.ibm.ws.kernel.boot.cmdline.EnvCheck";
    private static final Logger logger = Logger.getLogger(LibertyAppService.class.getName());
    private final ResourceLocator locator;

    LibertyAppService(ResourceLocator locator) {
        this.locator = locator;
    }

    @Override
    public Path getDeploymentDir() {
        Path serverDir = Paths.get("", new String[0]).toAbsolutePath();
        String wlpUserDir = System.getenv("WLP_USER_DIR");
        String wlpOutputDir = System.getenv("WLP_OUTPUT_DIR");
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Using WLP_USER_DIR {0}, WLP_OUTPUT_DIR {1}.", new Object[]{wlpUserDir, wlpOutputDir});
        }
        if (wlpUserDir != null && wlpOutputDir != null && !Paths.get(wlpOutputDir, new String[0]).equals(Paths.get(wlpUserDir, "servers"))) {
            Path serverName = serverDir.getFileName();
            serverDir = Paths.get(wlpUserDir, "servers").resolve(serverName);
        }
        return serverDir.resolve("dropins");
    }

    @Override
    @Nullable
    public Class<?> getServerClass() {
        return this.locator.findClass(SERVICE_CLASS_NAME);
    }
}

