/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.resourceproviders;

import io.opentelemetry.contrib.resourceproviders.AppServer;
import io.opentelemetry.contrib.resourceproviders.ResourceLocator;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class WildflyAppServer
implements AppServer {
    private static final Logger logger = Logger.getLogger(WildflyAppServer.class.getName());
    private static final String SERVICE_CLASS_NAME = "org.jboss.modules.Main";
    private final ResourceLocator locator;

    WildflyAppServer(ResourceLocator locator) {
        this.locator = locator;
    }

    @Override
    @Nullable
    public Path getDeploymentDir() throws URISyntaxException {
        String programArguments = System.getProperty("sun.java.command");
        logger.log(Level.FINE, "Started with arguments {0}.", programArguments);
        if (programArguments == null) {
            return null;
        }
        if (!programArguments.contains("org.jboss.as.standalone")) {
            return null;
        }
        String jbossBaseDir = System.getenv("JBOSS_BASE_DIR");
        if (jbossBaseDir != null) {
            logger.log(Level.FINE, "Using JBOSS_BASE_DIR {0}.", jbossBaseDir);
            return Paths.get(jbossBaseDir, "deployments");
        }
        Class<?> serverClass = this.getServerClass();
        if (serverClass == null) {
            return null;
        }
        URL jarUrl = this.locator.getClassLocation(serverClass);
        Path jarPath = Paths.get(jarUrl.toURI());
        Path parent = jarPath.getParent();
        if (parent == null) {
            return null;
        }
        return parent.resolve("standalone/deployments");
    }

    @Override
    public boolean isValidAppName(Path path) {
        return AppServer.super.isValidAppName(path);
    }

    @Override
    @Nullable
    public Class<?> getServerClass() {
        return this.locator.findClass(SERVICE_CLASS_NAME);
    }
}

