/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.resourceproviders;

import io.opentelemetry.contrib.resourceproviders.ServiceNameDetector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class DelegatingServiceNameDetector
implements ServiceNameDetector {
    private static final Logger logger = Logger.getLogger(DelegatingServiceNameDetector.class.getName());
    private final List<ServiceNameDetector> delegates;

    DelegatingServiceNameDetector(List<ServiceNameDetector> delegates) {
        this.delegates = Collections.unmodifiableList(new ArrayList<ServiceNameDetector>(delegates));
    }

    @Override
    @Nullable
    public String detect() {
        for (ServiceNameDetector detector : this.delegates) {
            try {
                String name = detector.detect();
                if (name == null) continue;
                return name;
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Service name detector '" + detector.getClass().getSimpleName() + "' failed with", exception);
            }
        }
        return null;
    }
}

