/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.resourceproviders;

import io.opentelemetry.contrib.resourceproviders.AppServer;
import io.opentelemetry.contrib.resourceproviders.ResourceLocator;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

class TomeeAppServer
implements AppServer {
    private static final String SERVER_CLASS_NAME = "org.apache.catalina.startup.Bootstrap";
    private final ResourceLocator locator;

    TomeeAppServer(ResourceLocator locator) {
        this.locator = locator;
    }

    @Override
    @Nullable
    public Path getDeploymentDir() throws URISyntaxException {
        Path rootDir = this.getRootDir();
        if (rootDir == null) {
            return null;
        }
        if (!Files.isRegularFile(rootDir.resolve("conf/tomee.xml"), new LinkOption[0])) {
            return null;
        }
        return rootDir.resolve("apps");
    }

    @Override
    @Nullable
    public Class<?> getServerClass() {
        return this.locator.findClass(SERVER_CLASS_NAME);
    }

    @Nullable
    private Path getRootDir() throws URISyntaxException {
        String catalinaBase = System.getProperty("catalina.base");
        if (catalinaBase != null) {
            return Paths.get(catalinaBase, new String[0]);
        }
        String catalinaHome = System.getProperty("catalina.home");
        if (catalinaHome != null) {
            return Paths.get(catalinaHome, new String[0]);
        }
        Class<?> serverClass = this.getServerClass();
        if (serverClass == null) {
            return null;
        }
        URL jarUrl = this.locator.getClassLocation(serverClass);
        Path jarPath = Paths.get(jarUrl.toURI());
        Path parent = jarPath.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getParent();
    }
}

