/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.resourceproviders;

import com.google.auto.service.AutoService;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.contrib.resourceproviders.CommonAppServersServiceNameDetector;
import io.opentelemetry.contrib.resourceproviders.ServiceNameDetector;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ConditionalResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@AutoService(value={ResourceProvider.class})
public final class AppServerServiceNameProvider
implements ConditionalResourceProvider {
    private static final Logger logger = Logger.getLogger(AppServerServiceNameProvider.class.getName());
    private final ServiceNameDetector detector;

    public AppServerServiceNameProvider() {
        this(CommonAppServersServiceNameDetector.create());
    }

    AppServerServiceNameProvider(ServiceNameDetector detector) {
        this.detector = detector;
    }

    public Resource createResource(ConfigProperties config) {
        String serviceName = this.detectServiceName();
        if (serviceName == null) {
            logger.log(Level.WARNING, "Service name could not be detected using common application server strategies.");
            return Resource.empty();
        }
        logger.log(Level.INFO, "Auto-detected service name {0}.", serviceName);
        return Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)serviceName));
    }

    @Nullable
    private String detectServiceName() {
        try {
            return this.detector.detect();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Failed to find a service name using common application server strategies: ", e);
            return null;
        }
    }

    public boolean shouldApply(ConfigProperties config, Resource existing) {
        String serviceName = config.getString("otel.service.name");
        if (serviceName != null) {
            logger.log(Level.FINE, "Skipping AppServerServiceName detection, otel.service.name is already set to {0}", serviceName);
            return false;
        }
        Map resourceAttributes = config.getMap("otel.resource.attributes");
        if (resourceAttributes.containsKey(ResourceAttributes.SERVICE_NAME.getKey())) {
            logger.log(Level.FINE, "Skipping AppServerServiceName detection, otel.resource.attributes already contains {0}", resourceAttributes.get(ResourceAttributes.SERVICE_NAME.getKey()));
            return false;
        }
        String existingName = (String)existing.getAttribute(ResourceAttributes.SERVICE_NAME);
        if (!"unknown_service:java".equals(existingName)) {
            logger.log(Level.FINE, "Skipping AppServerServiceName detection, resource already contains {0}", existingName);
            return false;
        }
        return true;
    }

    public int order() {
        return 200;
    }
}

