/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.resourceproviders;

import io.opentelemetry.contrib.resourceproviders.AppServer;
import io.opentelemetry.contrib.resourceproviders.ResourceLocator;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

class TomcatAppServer
implements AppServer {
    private static final String SERVER_CLASS_NAME = "org.apache.catalina.startup.Bootstrap";
    private final ResourceLocator locator;

    TomcatAppServer(ResourceLocator locator) {
        this.locator = locator;
    }

    @Override
    public boolean isValidAppName(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            String name = path.getFileName().toString();
            return !"docs".equals(name) && !"examples".equals(name) && !"host-manager".equals(name) && !"manager".equals(name);
        }
        return true;
    }

    @Override
    public boolean isValidResult(Path path, @Nullable String result) {
        String name = path.getFileName().toString();
        return !"ROOT".equals(name) || !"Welcome to Tomcat".equals(result);
    }

    @Override
    @Nullable
    public Path getDeploymentDir() throws URISyntaxException {
        String catalinaBase = System.getProperty("catalina.base");
        if (catalinaBase != null) {
            return Paths.get(catalinaBase, "webapps");
        }
        String catalinaHome = System.getProperty("catalina.home");
        if (catalinaHome != null) {
            return Paths.get(catalinaHome, "webapps");
        }
        Class<?> serverClass = this.getServerClass();
        if (serverClass == null) {
            return null;
        }
        URL jarUrl = this.locator.getClassLocation(serverClass);
        Path jarPath = Paths.get(jarUrl.toURI());
        return TomcatAppServer.getWebappsDir(jarPath);
    }

    @Nullable
    private static Path getWebappsDir(Path jarPath) {
        Path parent = jarPath.getParent();
        if (parent == null) {
            return null;
        }
        Path grandparent = parent.getParent();
        return grandparent == null ? null : grandparent.resolve("webapps");
    }

    @Override
    @Nullable
    public Class<?> getServerClass() {
        return this.locator.findClass(SERVER_CLASS_NAME);
    }

    @Override
    public boolean supportsEar() {
        return false;
    }
}

