/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.prometheus.clientbridge;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.contrib.metrics.prometheus.clientbridge.NameSanitizer;
import io.opentelemetry.contrib.metrics.prometheus.clientbridge.Serializer;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongExemplarData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.metrics.data.SummaryPointData;
import io.opentelemetry.sdk.metrics.data.ValueAtQuantile;
import io.prometheus.client.Collector;
import io.prometheus.client.exemplars.Exemplar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;

final class MetricAdapter {
    static final String SAMPLE_SUFFIX_COUNT = "_count";
    static final String SAMPLE_SUFFIX_SUM = "_sum";
    static final String SAMPLE_SUFFIX_BUCKET = "_bucket";
    static final String LABEL_NAME_QUANTILE = "quantile";
    static final String LABEL_NAME_LE = "le";
    static final Function<String, String> sanitizer = new NameSanitizer();

    static Collector.MetricFamilySamples toMetricFamilySamples(MetricData metricData) {
        String cleanMetricName = MetricAdapter.cleanMetricName(metricData.getName());
        Collector.Type type = MetricAdapter.toMetricFamilyType(metricData);
        return new Collector.MetricFamilySamples(cleanMetricName, type, metricData.getDescription(), MetricAdapter.toSamples(cleanMetricName, metricData.getType(), Serializer.getPoints(metricData)));
    }

    private static String cleanMetricName(String descriptorMetricName) {
        return Collector.sanitizeMetricName((String)descriptorMetricName);
    }

    static Collector.Type toMetricFamilyType(MetricData metricData) {
        switch (metricData.getType()) {
            case LONG_GAUGE: 
            case DOUBLE_GAUGE: {
                return Collector.Type.GAUGE;
            }
            case LONG_SUM: {
                SumData longSumData = metricData.getLongSumData();
                if (longSumData.isMonotonic() && longSumData.getAggregationTemporality() == AggregationTemporality.CUMULATIVE) {
                    return Collector.Type.COUNTER;
                }
                return Collector.Type.GAUGE;
            }
            case DOUBLE_SUM: {
                SumData doubleSumData = metricData.getDoubleSumData();
                if (doubleSumData.isMonotonic() && doubleSumData.getAggregationTemporality() == AggregationTemporality.CUMULATIVE) {
                    return Collector.Type.COUNTER;
                }
                return Collector.Type.GAUGE;
            }
            case SUMMARY: {
                return Collector.Type.SUMMARY;
            }
            case HISTOGRAM: {
                return Collector.Type.HISTOGRAM;
            }
            case EXPONENTIAL_HISTOGRAM: {
                return Collector.Type.UNKNOWN;
            }
        }
        return Collector.Type.UNKNOWN;
    }

    static List<Collector.MetricFamilySamples.Sample> toSamples(String name, MetricDataType type, Collection<? extends PointData> points) {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>(MetricAdapter.estimateNumSamples(points.size(), type));
        for (PointData pointData : points) {
            Attributes attributes = pointData.getAttributes();
            ArrayList<String> labelNames = new ArrayList<String>(attributes.size());
            ArrayList<String> labelValues = new ArrayList<String>(attributes.size());
            attributes.forEach((key, value) -> {
                String sanitizedLabelName = sanitizer.apply(key.getKey());
                labelNames.add(sanitizedLabelName);
                labelValues.add(value == null ? "" : value.toString());
            });
            switch (type) {
                case DOUBLE_GAUGE: 
                case DOUBLE_SUM: {
                    DoublePointData doublePoint = (DoublePointData)pointData;
                    samples.add(MetricAdapter.createSample(name, labelNames, labelValues, doublePoint.getValue(), null, doublePoint.getEpochNanos()));
                    break;
                }
                case LONG_GAUGE: 
                case LONG_SUM: {
                    LongPointData longPoint = (LongPointData)pointData;
                    samples.add(MetricAdapter.createSample(name, labelNames, labelValues, longPoint.getValue(), null, longPoint.getEpochNanos()));
                    break;
                }
                case SUMMARY: {
                    MetricAdapter.addSummarySamples((SummaryPointData)pointData, name, labelNames, labelValues, samples);
                    break;
                }
                case HISTOGRAM: {
                    MetricAdapter.addHistogramSamples((HistogramPointData)pointData, name, labelNames, labelValues, samples);
                    break;
                }
            }
        }
        return samples;
    }

    private static void addSummarySamples(SummaryPointData doubleSummaryPoint, String name, List<String> labelNames, List<String> labelValues, List<Collector.MetricFamilySamples.Sample> samples) {
        samples.add(MetricAdapter.createSample(name + SAMPLE_SUFFIX_COUNT, labelNames, labelValues, doubleSummaryPoint.getCount(), null, doubleSummaryPoint.getEpochNanos()));
        samples.add(MetricAdapter.createSample(name + SAMPLE_SUFFIX_SUM, labelNames, labelValues, doubleSummaryPoint.getSum(), null, doubleSummaryPoint.getEpochNanos()));
        List valueAtQuantiles = doubleSummaryPoint.getValues();
        ArrayList<String> labelNamesWithQuantile = new ArrayList<String>(labelNames.size() + 1);
        labelNamesWithQuantile.addAll(labelNames);
        labelNamesWithQuantile.add(LABEL_NAME_QUANTILE);
        for (ValueAtQuantile valueAtQuantile : valueAtQuantiles) {
            ArrayList<String> labelValuesWithQuantile = new ArrayList<String>(labelValues.size() + 1);
            labelValuesWithQuantile.addAll(labelValues);
            labelValuesWithQuantile.add(Collector.doubleToGoString((double)valueAtQuantile.getQuantile()));
            samples.add(MetricAdapter.createSample(name, labelNamesWithQuantile, labelValuesWithQuantile, valueAtQuantile.getValue(), null, doubleSummaryPoint.getEpochNanos()));
        }
    }

    private static void addHistogramSamples(HistogramPointData histogramPointData, String name, List<String> labelNames, List<String> labelValues, List<Collector.MetricFamilySamples.Sample> samples) {
        samples.add(MetricAdapter.createSample(name + SAMPLE_SUFFIX_COUNT, labelNames, labelValues, histogramPointData.getCount(), null, histogramPointData.getEpochNanos()));
        samples.add(MetricAdapter.createSample(name + SAMPLE_SUFFIX_SUM, labelNames, labelValues, histogramPointData.getSum(), null, histogramPointData.getEpochNanos()));
        ArrayList<String> labelNamesWithLe = new ArrayList<String>(labelNames.size() + 1);
        labelNamesWithLe.addAll(labelNames);
        labelNamesWithLe.add(LABEL_NAME_LE);
        long cumulativeCount = 0L;
        List counts = histogramPointData.getCounts();
        for (int i = 0; i < counts.size(); ++i) {
            ArrayList<String> labelValuesWithLe = new ArrayList<String>(labelValues.size() + 1);
            double boundary = Serializer.getBucketUpperBound(histogramPointData, i);
            labelValuesWithLe.addAll(labelValues);
            labelValuesWithLe.add(Collector.doubleToGoString((double)boundary));
            samples.add(MetricAdapter.createSample(name + SAMPLE_SUFFIX_BUCKET, labelNamesWithLe, labelValuesWithLe, cumulativeCount += ((Long)counts.get(i)).longValue(), MetricAdapter.filterExemplars(histogramPointData.getExemplars(), Serializer.getBucketLowerBound(histogramPointData, i), boundary), histogramPointData.getEpochNanos()));
        }
    }

    @Nullable
    private static ExemplarData filterExemplars(Collection<? extends ExemplarData> exemplars, double min, double max) {
        ExemplarData result = null;
        for (ExemplarData exemplarData : exemplars) {
            double value = MetricAdapter.getExemplarValue(exemplarData);
            if (!(value <= max) || !(value > min)) continue;
            result = exemplarData;
        }
        return result;
    }

    private static int estimateNumSamples(int numPoints, MetricDataType type) {
        if (type == MetricDataType.SUMMARY) {
            return numPoints * 4;
        }
        return numPoints;
    }

    private static Collector.MetricFamilySamples.Sample createSample(String name, List<String> labelNames, List<String> labelValues, double value, @Nullable ExemplarData exemplar, long timestampNanos) {
        if (exemplar != null) {
            return new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, value, MetricAdapter.toPrometheusExemplar(exemplar), Long.valueOf(TimeUnit.MILLISECONDS.convert(timestampNanos, TimeUnit.NANOSECONDS)));
        }
        return new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, value, null, Long.valueOf(TimeUnit.MILLISECONDS.convert(timestampNanos, TimeUnit.NANOSECONDS)));
    }

    private static Exemplar toPrometheusExemplar(ExemplarData exemplar) {
        SpanContext spanContext = exemplar.getSpanContext();
        if (spanContext.isValid()) {
            return new Exemplar(MetricAdapter.getExemplarValue(exemplar), Long.valueOf(TimeUnit.NANOSECONDS.toMillis(exemplar.getEpochNanos())), new String[]{"trace_id", spanContext.getTraceId(), "span_id", spanContext.getSpanId()});
        }
        return new Exemplar(MetricAdapter.getExemplarValue(exemplar), new String[0]);
    }

    private static double getExemplarValue(ExemplarData exemplar) {
        return exemplar instanceof DoubleExemplarData ? ((DoubleExemplarData)exemplar).getValue() : (double)((LongExemplarData)exemplar).getValue();
    }

    private MetricAdapter() {
    }
}

