/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.prometheus.clientbridge;

import io.opentelemetry.contrib.metrics.prometheus.clientbridge.MetricAdapter;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.CollectionRegistration;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.internal.export.MetricProducer;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public final class PrometheusCollector
implements MetricReader {
    private final Collector collector;
    private volatile MetricProducer metricProducer = MetricProducer.noop();

    PrometheusCollector() {
        this.collector = new CollectorImpl(() -> this.getMetricProducer().collectAllMetrics());
        this.collector.register();
    }

    public static PrometheusCollector create() {
        return new PrometheusCollector();
    }

    private MetricProducer getMetricProducer() {
        return this.metricProducer;
    }

    public void register(CollectionRegistration registration) {
        this.metricProducer = MetricProducer.asMetricProducer((CollectionRegistration)registration);
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return AggregationTemporality.CUMULATIVE;
    }

    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        CollectorRegistry.defaultRegistry.unregister(this.collector);
        return CompletableResultCode.ofSuccess();
    }

    private static class CollectorImpl
    extends Collector {
        private final Supplier<Collection<MetricData>> metricSupplier;

        private CollectorImpl(Supplier<Collection<MetricData>> metricSupplier) {
            this.metricSupplier = metricSupplier;
        }

        public List<Collector.MetricFamilySamples> collect() {
            Collection<MetricData> allMetrics = this.metricSupplier.get();
            ArrayList<Collector.MetricFamilySamples> allSamples = new ArrayList<Collector.MetricFamilySamples>(allMetrics.size());
            for (MetricData metricData : allMetrics) {
                allSamples.add(MetricAdapter.toMetricFamilySamples(metricData));
            }
            return Collections.unmodifiableList(allSamples);
        }
    }
}

