/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.eventbridge;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.otlp.AnyValueMarshaler;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.data.internal.ExtendedLogRecordData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class EventToSpanEventBridge
implements LogRecordProcessor {
    private static final Logger logger = Logger.getLogger(EventToSpanEventBridge.class.getName());
    private static final AttributeKey<Long> LOG_RECORD_OBSERVED_TIME_UNIX_NANO = AttributeKey.longKey((String)"log.record.observed_time_unix_nano");
    private static final AttributeKey<Long> LOG_RECORD_SEVERITY_NUMBER = AttributeKey.longKey((String)"log.record.severity_number");
    private static final AttributeKey<String> LOG_RECORD_BODY = AttributeKey.stringKey((String)"log.record.body");
    private static final AttributeKey<Long> LOG_RECORD_DROPPED_ATTRIBUTES_COUNT = AttributeKey.longKey((String)"log.record.dropped_attributes_count");

    private EventToSpanEventBridge() {
    }

    public static EventToSpanEventBridge create() {
        return new EventToSpanEventBridge();
    }

    public void onEmit(Context context, ReadWriteLogRecord logRecord) {
        LogRecordData logRecordData = logRecord.toLogRecordData();
        if (!(logRecordData instanceof ExtendedLogRecordData)) {
            return;
        }
        String eventName = ((ExtendedLogRecordData)logRecordData).getEventName();
        if (eventName == null) {
            return;
        }
        SpanContext logSpanContext = logRecordData.getSpanContext();
        if (!logSpanContext.isValid()) {
            return;
        }
        Span currentSpan = Span.current();
        if (!currentSpan.isRecording()) {
            return;
        }
        if (!currentSpan.getSpanContext().equals((Object)logSpanContext)) {
            return;
        }
        currentSpan.addEvent(eventName, EventToSpanEventBridge.toSpanEventAttributes(logRecordData), logRecordData.getTimestampEpochNanos(), TimeUnit.NANOSECONDS);
    }

    private static Attributes toSpanEventAttributes(LogRecordData logRecord) {
        int droppedAttributesCount;
        AttributesBuilder builder = logRecord.getAttributes().toBuilder();
        builder.put(LOG_RECORD_OBSERVED_TIME_UNIX_NANO, (Object)logRecord.getObservedTimestampEpochNanos());
        builder.put(LOG_RECORD_SEVERITY_NUMBER, logRecord.getSeverity().getSeverityNumber());
        Value body = logRecord.getBodyValue();
        if (body != null) {
            MarshalerWithSize marshaler = AnyValueMarshaler.create((Value)body);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                marshaler.writeJsonTo((OutputStream)out);
                builder.put(LOG_RECORD_BODY, (Object)out.toString(StandardCharsets.UTF_8.name()));
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error converting log record body to JSON", e);
            }
        }
        if ((droppedAttributesCount = logRecord.getTotalAttributeCount() - logRecord.getAttributes().size()) > 0) {
            builder.put(LOG_RECORD_DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
        }
        return builder.build();
    }

    public String toString() {
        return "EventToSpanEventBridge{}";
    }
}

