/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.interceptor.common;

import io.opentelemetry.contrib.interceptor.api.Interceptor;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;

public final class ComposableInterceptor<T>
implements Interceptor<T> {
    private final CopyOnWriteArrayList<Interceptor<T>> interceptors = new CopyOnWriteArrayList();

    public void add(Interceptor<T> interceptor) {
        this.interceptors.addIfAbsent(interceptor);
    }

    @Override
    @Nullable
    public T intercept(T item) {
        Interceptor<T> interceptor;
        T intercepted = item;
        Iterator<Interceptor<T>> iterator = this.interceptors.iterator();
        while (iterator.hasNext() && (intercepted = (interceptor = iterator.next()).intercept(intercepted)) != null) {
        }
        return intercepted;
    }
}

