/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer.internal.instruments;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.metrics.ExtendedDoubleCounterBuilder;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.DoubleCounterBuilder;
import io.opentelemetry.api.metrics.ObservableDoubleCounter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractCounter;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractInstrumentBuilder;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.MicrometerLongCounter;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.InstrumentState;
import java.util.function.Consumer;

final class MicrometerDoubleCounter
extends AbstractCounter
implements DoubleCounter,
ObservableDoubleMeasurement {
    private MicrometerDoubleCounter(InstrumentState instrumentState) {
        super(instrumentState);
    }

    public void add(double value) {
        this.increment(Attributes.empty(), value);
    }

    public void add(double value, Attributes attributes) {
        this.increment(attributes, value);
    }

    public void add(double value, Attributes attributes, Context context) {
        this.increment(attributes, value);
    }

    public void record(double value) {
        this.setMonotonically(Attributes.empty(), value);
    }

    public void record(double value, Attributes attributes) {
        this.setMonotonically(attributes, value);
    }

    public static DoubleCounterBuilder builder(MicrometerLongCounter.Builder parent) {
        return new Builder(parent);
    }

    static final class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements DoubleCounterBuilder,
    ExtendedDoubleCounterBuilder {
        private Builder(MicrometerLongCounter.Builder parent) {
            super(parent);
        }

        @Override
        public Builder self() {
            return this;
        }

        public MicrometerDoubleCounter build() {
            return new MicrometerDoubleCounter(this.createInstrumentState());
        }

        public ObservableDoubleCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            MicrometerDoubleCounter instrument = this.build();
            return instrument.registerDoubleCallback(callback, instrument);
        }
    }
}

