/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer.internal.instruments;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.metrics.ExtendedDoubleHistogramBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractHistogram;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractInstrumentBuilder;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.MicrometerLongHistogram;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.InstrumentState;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.MeterSharedState;
import java.util.List;

public final class MicrometerDoubleHistogram
extends AbstractHistogram
implements DoubleHistogram {
    private MicrometerDoubleHistogram(InstrumentState instrumentState) {
        super(instrumentState);
    }

    public void record(double value) {
        this.distribution(Attributes.empty()).record(value);
    }

    public void record(double value, Attributes attributes) {
        this.distribution(attributes).record(value);
    }

    public void record(double value, Attributes attributes, Context context) {
        this.distribution(attributes).record(value);
    }

    public static DoubleHistogramBuilder builder(MeterSharedState meterSharedState, String name) {
        return new Builder(meterSharedState, name);
    }

    static final class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements DoubleHistogramBuilder,
    ExtendedDoubleHistogramBuilder {
        private Builder(MeterSharedState meterSharedState, String name) {
            super(meterSharedState, name);
        }

        public DoubleHistogramBuilder setExplicitBucketBoundariesAdvice(List<Double> bucketBoundaries) {
            return (DoubleHistogramBuilder)super.setExplicitBucketBoundaries(bucketBoundaries);
        }

        @Override
        public Builder self() {
            return this;
        }

        public LongHistogramBuilder ofLongs() {
            return MicrometerLongHistogram.builder(this);
        }

        public DoubleHistogram build() {
            return new MicrometerDoubleHistogram(this.createInstrumentState());
        }
    }
}

