/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer.internal.instruments;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.metrics.ExtendedLongCounterBuilder;
import io.opentelemetry.api.metrics.DoubleCounterBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.ObservableLongCounter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractCounter;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractInstrumentBuilder;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.MicrometerDoubleCounter;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.InstrumentState;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.MeterSharedState;
import java.util.function.Consumer;

public final class MicrometerLongCounter
extends AbstractCounter
implements LongCounter,
ObservableLongMeasurement {
    private MicrometerLongCounter(InstrumentState instrumentState) {
        super(instrumentState);
    }

    public void add(long value) {
        this.increment(Attributes.empty(), value);
    }

    public void add(long value, Attributes attributes) {
        this.increment(attributes, value);
    }

    public void add(long value, Attributes attributes, Context context) {
        this.increment(attributes, value);
    }

    public void record(long value) {
        this.setMonotonically(Attributes.empty(), value);
    }

    public void record(long value, Attributes attributes) {
        this.setMonotonically(attributes, value);
    }

    public static LongCounterBuilder builder(MeterSharedState meterSharedState, String name) {
        return new Builder(meterSharedState, name);
    }

    static final class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements LongCounterBuilder,
    ExtendedLongCounterBuilder {
        private Builder(MeterSharedState meterSharedState, String name) {
            super(meterSharedState, name);
        }

        @Override
        public Builder self() {
            return this;
        }

        public DoubleCounterBuilder ofDoubles() {
            return MicrometerDoubleCounter.builder(this);
        }

        public MicrometerLongCounter build() {
            return new MicrometerLongCounter(this.createInstrumentState());
        }

        public ObservableLongCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            MicrometerLongCounter instrument = this.build();
            return instrument.registerLongCallback(callback, instrument);
        }
    }
}

