/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer.internal.instruments;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class AtomicDoubleCounter {
    private static final AtomicLongFieldUpdater<AtomicDoubleCounter> BITS_UPDATER = AtomicLongFieldUpdater.newUpdater(AtomicDoubleCounter.class, "doubleBits");
    private volatile long doubleBits;

    AtomicDoubleCounter() {
    }

    double current() {
        return Double.longBitsToDouble(this.doubleBits);
    }

    boolean increment(double increment) {
        double update;
        double current;
        while (!this.compareAndSet(current = this.current(), update = current + increment)) {
        }
        return true;
    }

    boolean set(double value) {
        BITS_UPDATER.set(this, Double.doubleToRawLongBits(value));
        return true;
    }

    boolean setMonotonically(double value) {
        double current;
        do {
            if (!((current = this.current()) > value)) continue;
            return false;
        } while (!this.compareAndSet(current, value));
        return true;
    }

    boolean compareAndSet(double expected, double update) {
        long expectedBits = Double.doubleToRawLongBits(expected);
        long updateBits = Double.doubleToRawLongBits(update);
        return BITS_UPDATER.compareAndSet(this, expectedBits, updateBits);
    }
}

