/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer.internal.instruments;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.FunctionCounter;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractInstrument;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AtomicDoubleCounter;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.InstrumentState;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

abstract class AbstractCounter
extends AbstractInstrument {
    private final Map<Attributes, AtomicDoubleCounter> counterMap = new ConcurrentHashMap<Attributes, AtomicDoubleCounter>();

    protected AbstractCounter(InstrumentState instrumentState) {
        super(instrumentState);
    }

    protected final Counter counter(Attributes attributes) {
        return Counter.builder((String)this.name()).tags(this.attributesToTags(attributes)).description(this.description()).baseUnit(this.unit()).register(this.meterRegistry());
    }

    protected final void increment(Attributes attributes, double value) {
        if (value >= 0.0) {
            this.counter(attributes).increment(value);
        }
    }

    protected final void setMonotonically(Attributes attributes, double value) {
        this.counterMap.computeIfAbsent(this.effectiveAttributes(attributes), this::createAsyncCounter).setMonotonically(value);
    }

    private AtomicDoubleCounter createAsyncCounter(Attributes attributes) {
        AtomicDoubleCounter counter = new AtomicDoubleCounter();
        FunctionCounter.builder((String)this.name(), (Object)counter, AtomicDoubleCounter::current).description(this.description()).baseUnit(this.unit()).tags(this.attributesToTags(attributes)).register(this.meterRegistry());
        return counter;
    }
}

