/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer.internal.instruments;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.metrics.ExtendedLongHistogramBuilder;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractHistogram;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractInstrumentBuilder;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.MicrometerDoubleHistogram;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.InstrumentState;
import java.util.List;

final class MicrometerLongHistogram
extends AbstractHistogram
implements LongHistogram {
    private MicrometerLongHistogram(InstrumentState instrumentState) {
        super(instrumentState);
    }

    public void record(long value) {
        this.distribution(Attributes.empty()).record((double)value);
    }

    public void record(long value, Attributes attributes) {
        this.distribution(attributes).record((double)value);
    }

    public void record(long value, Attributes attributes, Context context) {
        this.distribution(attributes).record((double)value);
    }

    public static LongHistogramBuilder builder(MicrometerDoubleHistogram.Builder parent) {
        return new Builder(parent);
    }

    static final class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements LongHistogramBuilder,
    ExtendedLongHistogramBuilder {
        private Builder(MicrometerDoubleHistogram.Builder parent) {
            super(parent);
        }

        public LongHistogramBuilder setExplicitBucketBoundariesAdvice(List<Long> bucketBoundaries) {
            return (LongHistogramBuilder)super.setExplicitBucketBoundaries(bucketBoundaries);
        }

        @Override
        public Builder self() {
            return this;
        }

        public LongHistogram build() {
            return new MicrometerLongHistogram(this.createInstrumentState());
        }
    }
}

