/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer;

import io.opentelemetry.contrib.metrics.micrometer.CallbackRegistrar;
import io.opentelemetry.contrib.metrics.micrometer.CallbackRegistration;
import io.opentelemetry.contrib.metrics.micrometer.ScheduledCallbackRegistrarBuilder;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class ScheduledCallbackRegistrar
implements CallbackRegistrar {
    private final ScheduledExecutorService scheduledExecutorService;
    private final long period;
    private final TimeUnit timeUnit;
    private final boolean ownsExecutor;
    private final List<Runnable> callbacks;
    @Nullable
    private volatile ScheduledFuture<?> scheduledFuture;

    ScheduledCallbackRegistrar(ScheduledExecutorService scheduledExecutorService, long period, TimeUnit timeUnit, boolean ownsExecutor) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.period = period;
        this.timeUnit = timeUnit;
        this.ownsExecutor = ownsExecutor;
        this.callbacks = new CopyOnWriteArrayList<Runnable>();
    }

    public static ScheduledCallbackRegistrarBuilder builder(ScheduledExecutorService scheduledExecutorService) {
        Objects.requireNonNull(scheduledExecutorService, "scheduledExecutorService");
        return new ScheduledCallbackRegistrarBuilder(scheduledExecutorService);
    }

    @Override
    public CallbackRegistration registerCallback(Runnable callback) {
        if (callback != null) {
            this.ensureScheduled();
            this.callbacks.add(callback);
            return () -> this.callbacks.remove(callback);
        }
        return () -> {};
    }

    private synchronized void ensureScheduled() {
        if (this.scheduledFuture == null) {
            this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(this::poll, this.period, this.period, this.timeUnit);
        }
    }

    private void poll() {
        for (Runnable callback : this.callbacks) {
            callback.run();
        }
    }

    @Override
    public synchronized void close() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
        if (this.ownsExecutor) {
            this.scheduledExecutorService.shutdown();
        }
    }
}

