/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer.internal.instruments;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongGaugeBuilder;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractGauge;
import io.opentelemetry.contrib.metrics.micrometer.internal.instruments.AbstractInstrumentBuilder;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.InstrumentState;
import io.opentelemetry.contrib.metrics.micrometer.internal.state.MeterSharedState;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class MicrometerLongGauge
extends AbstractGauge {
    public MicrometerLongGauge(InstrumentState instrumentState) {
        super(instrumentState);
    }

    public static LongGaugeBuilder builder(MeterSharedState meterSharedState, String name, @Nullable String description, @Nullable String unit) {
        return new Builder(meterSharedState, name, description, unit);
    }

    private static class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements LongGaugeBuilder {
        private Builder(MeterSharedState meterSharedState, String name, @Nullable String description, @Nullable String unit) {
            super(meterSharedState, name, description, unit);
        }

        @Override
        public Builder self() {
            return this;
        }

        public ObservableLongGauge buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            final MicrometerLongGauge instrument = new MicrometerLongGauge(this.createInstrumentState());
            return instrument.registerLongCallback(callback, new ObservableLongMeasurement(){

                public void record(long value) {
                    this.record(value, Attributes.empty());
                }

                public void record(long value, Attributes attributes) {
                    instrument.record(value, attributes);
                }
            });
        }
    }
}

